/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class FixTask
extends PleaseWaitRunnable {
    private final Collection<TestError> testErrors;
    private boolean canceled;

    public FixTask(Collection<TestError> testErrors) {
        super(I18n.tr((String)"Fixing errors ...", (Object[])new Object[0]), false);
        this.testErrors = testErrors == null ? new ArrayList() : testErrors;
    }

    protected void cancel() {
        this.canceled = true;
    }

    protected void finish() {
    }

    protected void fixError(TestError error) throws InterruptedException, InvocationTargetException {
        if (error.isFixable()) {
            final Command fixCommand = error.getFix();
            if (fixCommand != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.undoRedo.addNoRedraw(fixCommand);
                    }
                });
            }
            error.setIgnored(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        ProgressMonitor monitor = this.getProgressMonitor();
        try {
            monitor.setTicksCount(this.testErrors.size());
            int i = 0;
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Main.main.getCurrentDataSet().beginUpdate();
                }
            });
            try {
                for (TestError error : this.testErrors) {
                    monitor.subTask(I18n.tr((String)"Fixing ({0}/{1}): ''{2}''", (Object[])new Object[]{++i, this.testErrors.size(), error.getMessage()}));
                    if (!this.canceled) break block10;
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Main.main.getCurrentDataSet().endUpdate();
                    }
                });
                throw throwable;
            }
            {
                TestError error;
                block10: {
                    SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                this.fixError(error);
                monitor.worked(1);
                continue;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            monitor.subTask(I18n.tr((String)"Updating map ...", (Object[])new Object[0]));
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Main.main.undoRedo.afterAdd();
                    Main.map.repaint();
                    Main.main.getCurrentDataSet().fireSelectionChanged();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            monitor.finishTask();
        }
    }
}

