/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.plugins.pt_assistant.actions.FixTask;
import org.openstreetmap.josm.plugins.pt_assistant.actions.IncompleteMembersDownloadThread;
import org.openstreetmap.josm.plugins.pt_assistant.gui.IncompleteMembersDownloadDialog;
import org.openstreetmap.josm.plugins.pt_assistant.gui.ProceedDialog;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.RouteChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.SegmentChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;
import org.openstreetmap.josm.tools.I18n;

public class PTAssitantValidatorTest
extends Test {
    public static final int ERROR_CODE_SORTING = 3711;
    public static final int ERROR_CODE_ROAD_TYPE = 3721;
    public static final int ERROR_CODE_DIRECTION = 3731;
    public static final int ERROR_CODE_END_STOP = 3141;
    public static final int ERROR_CODE_SPLIT_WAY = 3142;
    public static final int ERROR_CODE_RELAITON_MEMBER_ROLES = 3143;

    public PTAssitantValidatorTest() {
        super(I18n.tr((String)"Public Transport Assistant tests", (Object[])new Object[0]), I18n.tr((String)"Check if route relations are compatible with public transport version 2", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        boolean downloadSuccessful;
        if (!RouteUtils.isTwoDirectionRoute(r)) {
            return;
        }
        if (r.hasIncompleteMembers() && !(downloadSuccessful = this.downloadIncompleteMembers(r))) {
            return;
        }
        if (r.hasIncompleteMembers()) {
            return;
        }
        Node n = new Node();
        for (RelationMember rm : r.getMembers()) {
            if (!rm.isNode()) continue;
            n.setCoor(rm.getNode().getCoor());
            break;
        }
        WayChecker wayChecker = new WayChecker(r, this);
        this.errors.addAll(wayChecker.getErrors());
        if (this.errors.isEmpty()) {
            this.proceedWithSorting(r);
        } else {
            this.proceedAfterWayCheckerErrors(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadIncompleteMembers(Relation r) {
        IncompleteMembersDownloadDialog incompleteMembersDownloadDialog = new IncompleteMembersDownloadDialog(r.getId());
        int userInput = incompleteMembersDownloadDialog.getUserSelection();
        if (userInput == 0) {
            IncompleteMembersDownloadThread t = new IncompleteMembersDownloadThread();
            t.start();
            IncompleteMembersDownloadThread incompleteMembersDownloadThread = t;
            synchronized (incompleteMembersDownloadThread) {
                try {
                    t.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void proceedAfterWayCheckerErrors(Relation r) {
        int numberOfDirectionErrors = 0;
        int numberOfRoadTypeErrors = 0;
        for (TestError e : this.errors) {
            if (e.getCode() == 3731) {
                ++numberOfDirectionErrors;
            }
            if (e.getCode() != 3721) continue;
            ++numberOfRoadTypeErrors;
        }
        ProceedDialog proceedDialog = new ProceedDialog(r.getId(), numberOfDirectionErrors, numberOfRoadTypeErrors);
        int userInput = proceedDialog.getUserSelection();
        if (userInput == 0) {
            this.fixErrorFromPlugin(this.errors);
            this.proceedWithSorting(r);
            return;
        }
        if (userInput == 1) {
            JOptionPane.showMessageDialog(null, "This is not implemented yet!");
            return;
        }
        if (userInput == 2) {
            this.proceedWithSorting(r);
        }
    }

    private void proceedWithSorting(Relation r) {
        RouteChecker routeChecker = new RouteChecker(r, this);
        List<TestError> routeCheckerErrors = routeChecker.getErrors();
        if (!routeCheckerErrors.isEmpty()) {
            this.errors.addAll(routeChecker.getErrors());
            return;
        }
        if (!routeChecker.getHasGap()) {
            // empty if block
        }
        this.proceedAfterSorting(r);
    }

    private void proceedAfterSorting(Relation r) {
        SegmentChecker segmentChecker = new SegmentChecker(r, this);
        if (!segmentChecker.getErrors().isEmpty()) {
            this.errors.addAll(segmentChecker.getErrors());
        }
        segmentChecker.performFirstStopTest();
        segmentChecker.performLastStopTest();
        this.errors.addAll(segmentChecker.getErrors());
    }

    public boolean isFixable(TestError testError) {
        return testError.getCode() == 3731 || testError.getCode() == 3721 || testError.getCode() == 3711;
    }

    public Command fixError(TestError testError) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (testError.getCode() == 3731 || testError.getCode() == 3721) {
            commands.add(this.fixErrorByRemovingWay(testError));
        }
        if (testError.getCode() == 3711) {
            commands.add(this.fixSortingError(testError));
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Fix error", (Object[])new Object[0]), commands);
    }

    private void fixErrorFromPlugin(List<TestError> testErrors) {
        FixTask fixTask = new FixTask(testErrors);
        Thread t = new Thread((Runnable)((Object)fixTask));
        t.start();
        try {
            t.join();
            this.errors.removeAll(testErrors);
        }
        catch (InterruptedException e) {
            JOptionPane.showMessageDialog(null, "Error occurred during fixing");
        }
    }

    private Command fixErrorByRemovingWay(TestError testError) {
        if (testError.getCode() != 3721 && testError.getCode() != 3731) {
            return null;
        }
        List primitives = (List)testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.get(0);
        List highlighted = (List)testError.getHighlighted();
        Way wayToRemove = (Way)highlighted.get(0);
        Relation modifiedRelation = new Relation(originalRelation);
        ArrayList<RelationMember> modifiedRelationMembers = new ArrayList<RelationMember>(originalRelation.getMembersCount() - 1);
        for (RelationMember rm : originalRelation.getMembers()) {
            if (!RouteUtils.isPTStop(rm)) continue;
            if (rm.getRole().equals("stop_position")) {
                RelationMember newMember;
                if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                    modifiedRelationMembers.add(newMember);
                    continue;
                }
                newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                modifiedRelationMembers.add(newMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        for (RelationMember rm : originalRelation.getMembers()) {
            Way wayToCheck;
            if (!RouteUtils.isPTWay(rm) || (wayToCheck = rm.getWay()) == wayToRemove) continue;
            if (rm.getRole().equals("forward") || rm.getRole().equals("backward")) {
                RelationMember modifiedMember = new RelationMember("", (OsmPrimitive)wayToCheck);
                modifiedRelationMembers.add(modifiedMember);
                continue;
            }
            modifiedRelationMembers.add(rm);
        }
        modifiedRelation.setMembers(modifiedRelationMembers);
        ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
        return changeCommand;
    }

    private Command fixSortingError(TestError testError) {
        if (testError.getCode() != 3711) {
            return null;
        }
        List primitives = (List)testError.getPrimitives();
        Relation originalRelation = (Relation)primitives.get(0);
        List members = originalRelation.getMembers();
        ArrayList<RelationMember> stops = new ArrayList<RelationMember>();
        ArrayList<RelationMember> ways = new ArrayList<RelationMember>();
        for (RelationMember member : members) {
            RelationMember modifiedMember;
            if (RouteUtils.isPTWay(member)) {
                if (member.getRole().equals("")) {
                    ways.add(member);
                    continue;
                }
                modifiedMember = new RelationMember("", (OsmPrimitive)member.getWay());
                ways.add(modifiedMember);
                continue;
            }
            if (member.getRole().equals("stop_positon")) {
                if (member.getType().equals((Object)OsmPrimitiveType.NODE)) {
                    modifiedMember = new RelationMember("stop", (OsmPrimitive)member.getNode());
                    stops.add(modifiedMember);
                    continue;
                }
                modifiedMember = new RelationMember("stop", (OsmPrimitive)member.getWay());
                stops.add(modifiedMember);
                continue;
            }
            stops.add(member);
        }
        RelationSorter sorter = new RelationSorter();
        List sortedWays = sorter.sortMembers(ways);
        Relation sortedRelation = new Relation(originalRelation);
        ArrayList<RelationMember> sortedRelationMembers = new ArrayList<RelationMember>(members.size());
        for (RelationMember rm : stops) {
            sortedRelationMembers.add(rm);
        }
        for (RelationMember rm : sortedWays) {
            sortedRelationMembers.add(rm);
        }
        sortedRelation.setMembers(sortedRelationMembers);
        ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)sortedRelation);
        return changeCommand;
    }

    private void performDummyTest(Relation r) {
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(r);
        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: dummy test warning", (Object[])new Object[0]), 3731, primitives));
    }
}

