/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class RouteUtils {
    private RouteUtils() {
    }

    public static boolean isTwoDirectionRoute(Relation r) {
        if (!r.hasKey("route") || !r.hasTag("public_transport:version", "2")) {
            return false;
        }
        return r.hasTag("route", "bus") || r.hasTag("route", "trolleybus") || r.hasTag("route", "share_taxi") || r.hasTag("route", "tram") || r.hasTag("route", "light_rail") || r.hasTag("route", "subway") || r.hasTag("route", "train");
    }

    public static boolean isPTStop(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE) && (rm.hasRole(new String[]{"stop"}) || rm.hasRole(new String[]{"stop_entry_only"}) || rm.hasRole(new String[]{"stop_exit_only"}) || rm.hasRole(new String[]{"platform"}) || rm.hasRole(new String[]{"platform_entry_only"}) || rm.hasRole(new String[]{"platform_exit_only"})) && (rm.getNode().hasTag("public_transport", "stop_position") || rm.getNode().hasTag("highway", "bus_stop") || rm.getNode().hasTag("public_transport", "platform") || rm.getNode().hasTag("public_transport", "platform_entry_only") || rm.getNode().hasTag("public_transport", "platform_exit_only") || rm.getNode().hasTag("highway", "platform") || rm.getNode().hasTag("highway", "platform_entry_only") || rm.getNode().hasTag("highway", "platform_exit_only") || rm.getNode().hasTag("railway", "platform") || rm.getNode().hasTag("railway", "platform_entry_only") || rm.getNode().hasTag("railway", "platform_exit_only"))) {
            return true;
        }
        return rm.getType().equals((Object)OsmPrimitiveType.WAY) && (rm.getWay().hasTag("public_transport", "platform") || rm.getWay().hasTag("public_transport", "platform_entry_only") || rm.getWay().hasTag("public_transport", "platform_exit_only") || rm.getWay().hasTag("highway", "platform") || rm.getWay().hasTag("highway", "platform_entry_only") || rm.getWay().hasTag("highway", "platform_exist_only") || rm.getWay().hasTag("railway", "platform") || rm.getWay().hasTag("railway", "platform_entry_only") || rm.getWay().hasTag("railway", "platform_exit_only"));
    }

    public static boolean isPTWay(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
            return false;
        }
        if (rm.getType().equals((Object)OsmPrimitiveType.WAY)) {
            return true;
        }
        Relation nestedRelation = rm.getRelation();
        for (RelationMember nestedRelationMember : nestedRelation.getMembers()) {
            if (nestedRelationMember.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWaySuitableForBuses(Way way) {
        if (way.hasTag("highway", "motorway") || way.hasTag("highway", "trunk") || way.hasTag("highway", "primary") || way.hasTag("highway", "secondary") || way.hasTag("highway", "tertiary") || way.hasTag("highway", "unclassified") || way.hasTag("highway", "road") || way.hasTag("highway", "residential") || way.hasTag("highway", "service") || way.hasTag("highway", "motorway_link") || way.hasTag("highway", "trunk_link") || way.hasTag("highway", "primary_link") || way.hasTag("highway", "secondary_link") || way.hasTag("highway", "tertiary_link") || way.hasTag("highway", "living_street") || way.hasTag("highway", "bus_guideway") || way.hasTag("highway", "road") || way.hasTag("cycleway", "share_busway") || way.hasTag("cycleway", "shared_lane")) {
            return true;
        }
        return way.hasTag("highway", "pedestrian") && (way.hasTag("bus", "yes") || way.hasTag("psv", "yes") || way.hasTag("bus", "designated") || way.hasTag("psv", "designated"));
    }

    public static boolean hasIncompleteMembers(Relation r) {
        if (r == null) {
            return true;
        }
        for (RelationMember rm : r.getMembers()) {
            if (!(rm.isNode() && rm.getNode().isIncomplete() || rm.isWay() && rm.getWay().isIncomplete()) && (!rm.isRelation() || !rm.getRelation().isIncomplete())) continue;
            return true;
        }
        return false;
    }
}

