/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMember;

public class PTStop
extends RelationMember {
    private Node stopPosition = null;
    private OsmPrimitive platform = null;
    private String name = "";

    public PTStop(RelationMember other) throws IllegalArgumentException {
        super(other);
        if ((other.hasRole(new String[]{"stop"}) || other.hasRole(new String[]{"stop_entry_only"}) || other.hasRole(new String[]{"stop_exit_only"})) && other.getType().equals((Object)OsmPrimitiveType.NODE)) {
            this.stopPosition = other.getNode();
            this.name = this.stopPosition.get("name");
        } else if (other.getRole().equals("platform") || other.getRole().equals("platform_entry_only") || other.getRole().equals("platform_exit_only")) {
            this.platform = other.getMember();
            this.name = this.platform.get("name");
        } else {
            throw new IllegalArgumentException("The RelationMember type does not match its role " + other.getMember().getName());
        }
    }

    public boolean addStopElement(RelationMember member) {
        if ((member.hasRole(new String[]{"stop"}) || member.hasRole(new String[]{"stop_entry_only"}) || member.hasRole(new String[]{"stop_exit_only"})) && member.getType().equals((Object)OsmPrimitiveType.NODE) && this.stopPosition == null) {
            this.stopPosition = member.getNode();
            return true;
        }
        if ((member.getRole().equals("platform") || member.getRole().equals("platform_entry_only") || member.getRole().equals("platform_exit_only")) && this.platform == null) {
            this.platform = member.getMember();
            return true;
        }
        return false;
    }

    public Node getStopPosition() {
        return this.stopPosition;
    }

    public OsmPrimitive getPlatform() {
        return this.platform;
    }

    public String getName() {
        return this.name;
    }

    public void setStopPosition(Node newStopPosition) {
        this.stopPosition = newStopPosition;
    }

    public List<Node> findPotentialStopPositions() {
        ArrayList<Node> potentialStopPositions = new ArrayList<Node>();
        if (this.platform == null) {
            return potentialStopPositions;
        }
        LatLon platformCenter = this.platform.getBBox().getCenter();
        Double ax = platformCenter.getX() - 0.002;
        Double bx = platformCenter.getX() + 0.002;
        Double ay = platformCenter.getY() - 0.002;
        Double by = platformCenter.getY() + 0.002;
        BBox platformBBox = new BBox(ax.doubleValue(), ay.doubleValue(), bx.doubleValue(), by.doubleValue());
        Collection allNodes = Main.getLayerManager().getEditDataSet().getNodes();
        for (Node currentNode : allNodes) {
            if (!platformBBox.bounds(currentNode.getBBox()) || !currentNode.hasTag("public_transport", "stop_position")) continue;
            potentialStopPositions.add(currentNode);
        }
        return potentialStopPositions;
    }
}

