/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.discovery.mac;

import java.util.List;
import java.util.regex.Pattern;
import uk.co.caprica.vlcj.binding.LibC;
import uk.co.caprica.vlcj.discovery.StandardNativeDiscoveryStrategy;
import uk.co.caprica.vlcj.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.version.LibVlcVersion;

public class DefaultMacNativeDiscoveryStrategy
extends StandardNativeDiscoveryStrategy {
    private static final Pattern[] FILENAME_PATTERNS = new Pattern[]{Pattern.compile("libvlc\\.dylib"), Pattern.compile("libvlccore\\.dylib")};
    private static final String PLUGIN_ENV_NAME = "VLC_PLUGIN_PATH";
    private static final String PLUGIN_PATH_FORMAT = "%s/../plugins";

    @Override
    protected Pattern[] getFilenamePatterns() {
        return FILENAME_PATTERNS;
    }

    @Override
    public final boolean supported() {
        return RuntimeUtil.isMac();
    }

    @Override
    protected void onGetDirectoryNames(List<String> directoryNames) {
        directoryNames.add("/Applications/VLC.app/Contents/MacOS/lib");
    }

    @Override
    public void onFound(String path) {
        if (LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_220)) {
            LibC.INSTANCE.setenv(PLUGIN_ENV_NAME, String.format(PLUGIN_PATH_FORMAT, path), 1);
        }
    }
}

