/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteDataManager;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTRouteSegment;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.StopToWayAssigner;
import org.openstreetmap.josm.plugins.pt_assistant.validation.Checker;
import org.openstreetmap.josm.tools.I18n;

public class SegmentChecker
extends Checker {
    private static List<PTRouteSegment> correctSegments = new ArrayList<PTRouteSegment>();
    private PTRouteDataManager manager;
    private StopToWayAssigner assigner;

    public SegmentChecker(Relation relation, Test test) {
        super(relation, test);
        this.manager = new PTRouteDataManager(relation);
        this.assigner = new StopToWayAssigner(this.manager.getPTWays());
    }

    public void performFirstStopTest() {
        this.performEndStopTest(this.manager.getFirstStop());
    }

    public void performLastStopTest() {
        this.performEndStopTest(this.manager.getLastStop());
    }

    private void performEndStopTest(PTStop endStop) {
        if (this.manager.getPTStopCount() < 2) {
            return;
        }
        if (endStop.getStopPosition() == null) {
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(this.relation);
            ArrayList<OsmPrimitive> highlighted = new ArrayList<OsmPrimitive>(1);
            highlighted.add(endStop.getPlatform());
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route should start and end with a stop_position", (Object[])new Object[0]), 3141, primitives, highlighted);
            this.errors.add(e);
            return;
        }
        PTWay endWay = this.assigner.get(endStop);
        boolean found = false;
        List<Way> primitivesOfEndWay = endWay.getWays();
        for (Way primitiveWay : primitivesOfEndWay) {
            if (primitiveWay.firstNode() != endStop.getStopPosition() && primitiveWay.lastNode() != endStop.getStopPosition()) continue;
            found = true;
        }
        if (!found) {
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(this.relation);
            ArrayList<Way> highlighted = new ArrayList<Way>();
            for (Way w : endWay.getWays()) {
                if (!w.getNodes().contains(endStop.getStopPosition())) continue;
                highlighted.add(w);
            }
            TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: First or last way needs to be split", (Object[])new Object[0]), 3142, primitives, highlighted);
            this.errors.add(e);
        }
    }

    private void performSegmentTest() {
    }
}

