/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.fix;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;

public class RemoveFromRelationCommand
extends Command {
    private final Relation r;
    private final List<RelationMember> members;

    public RemoveFromRelationCommand(Relation relation, List<RelationMember> membersToRemove) {
        this.r = relation;
        this.members = membersToRemove;
    }

    public boolean executeCommand() {
        JOptionPane.showMessageDialog(null, "in executionCommand method, start: " + this.r.getMembersCount());
        super.executeCommand();
        for (RelationMember rm : this.members) {
            if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                this.r.remove(new Long(rm.getNode().getId()).toString());
                continue;
            }
            if (!rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            this.r.remove(new Long(rm.getWay().getId()).toString());
        }
        this.r.setModified(true);
        JOptionPane.showMessageDialog(null, "in executeCommand method, end:  " + this.r.getMembersCount());
        return true;
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add((OsmPrimitive)this.r);
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Removed members from {0}", (Object[])new Object[]{this.r.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.r, this.members);
    }
}

