/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;

public class PTStop
extends RelationMember {
    private Node stopPosition = null;
    private OsmPrimitive platform = null;
    private Relation stopArea = null;
    private String name = "";

    public PTStop(RelationMember other) throws IllegalArgumentException {
        super(other);
        if (other.getRole().equals("stop") && other.getType().equals((Object)OsmPrimitiveType.NODE)) {
            this.stopPosition = other.getNode();
        } else if (other.getRole().equals("platform") || other.getRole().equals("platform_entry_only") || other.getRole().equals("platform_exit_only")) {
            this.platform = other.getMember();
        } else if (other.getRole().equals("stop_area") && other.getType().equals((Object)OsmPrimitiveType.RELATION)) {
            this.stopArea = other.getRelation();
            for (RelationMember rm : this.stopArea.getMembers()) {
                if (rm.getRole().equals("stop") && rm.isNode()) {
                    this.stopPosition = rm.getNode();
                }
                if (!rm.getRole().equals("platform") && !rm.getRole().equals("platform_entry_only") && !rm.getRole().equals("platform_exit_only")) continue;
                this.platform = rm.getMember();
            }
        } else {
            throw new IllegalArgumentException("The RelationMember type does not match its role");
        }
        this.name = other.getMember().get("name");
    }

    public boolean addStopElement(RelationMember member) {
        if (member.getRole().equals("stop") && member.getType().equals((Object)OsmPrimitiveType.NODE) && this.stopPosition == null) {
            this.stopPosition = member.getNode();
            return true;
        }
        if ((member.getRole().equals("platform") || member.getRole().equals("platform_entry_only") || member.getRole().equals("platform_exit_only")) && this.platform == null) {
            this.platform = member.getMember();
            return true;
        }
        if (member.getRole().equals("stop_area") && member.getType().equals((Object)OsmPrimitiveType.RELATION) && this.stopArea == null) {
            this.stopArea = member.getRelation();
            for (RelationMember rm : this.stopArea.getMembers()) {
                if (rm.getRole().equals("stop") && rm.isNode()) {
                    this.stopPosition = rm.getNode();
                }
                if (!rm.getRole().equals("platform") && !rm.getRole().equals("platform_entry_only") && !rm.getRole().equals("platform_exit_only")) continue;
                this.platform = rm.getMember();
            }
            return true;
        }
        return false;
    }

    public Node getStopPosition() {
        return this.stopPosition;
    }

    public OsmPrimitive getPlatform() {
        return this.platform;
    }

    public Relation getStopArea() {
        return this.stopArea;
    }

    public String getName() {
        return this.name;
    }
}

