/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTStop;
import org.openstreetmap.josm.plugins.pt_assistant.data.PTWay;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;

public class PTRouteDataManager {
    Relation relation;
    private List<PTStop> ptstops = new ArrayList<PTStop>();
    private List<PTWay> ptways = new ArrayList<PTWay>();

    public PTRouteDataManager(Relation relation) {
        this.relation = relation;
        PTStop prev = null;
        for (RelationMember member : this.relation.getMembers()) {
            if (RouteUtils.isPTStop(member)) {
                if (prev != null && prev.getName().equalsIgnoreCase(member.getMember().get("name"))) {
                    prev.addStopElement(member);
                    continue;
                }
                PTStop ptstop = new PTStop(member);
                this.ptstops.add(ptstop);
                prev = ptstop;
                continue;
            }
            PTWay ptway = new PTWay(member);
            this.ptways.add(ptway);
        }
    }

    public List<PTStop> getPTStops() {
        return this.ptstops;
    }

    public List<PTWay> getPTWays() {
        return this.ptways;
    }

    public int getPTStopCount() {
        return this.ptstops.size();
    }

    public int getPTWayCount() {
        return this.ptways.size();
    }

    public PTStop getFirstStop() {
        if (this.ptstops.isEmpty()) {
            return null;
        }
        return this.ptstops.get(0);
    }

    public PTStop getLastStop() {
        if (this.ptstops.isEmpty()) {
            return null;
        }
        return this.ptstops.get(this.ptstops.size() - 1);
    }
}

