/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.data;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class PTWay
extends RelationMember {
    private List<Way> ways = new ArrayList<Way>();

    public PTWay(RelationMember other) throws IllegalArgumentException {
        super(other);
        if (other.getType().equals((Object)OsmPrimitiveType.WAY)) {
            this.ways.add(other.getWay());
        } else if (other.getType().equals((Object)OsmPrimitiveType.RELATION)) {
            for (RelationMember rm : other.getRelation().getMembers()) {
                if (rm.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    this.ways.add(rm.getWay());
                    continue;
                }
                throw new IllegalArgumentException("A route relation member of OsmPrimitiveType.RELATION can only have ways as members");
            }
        } else {
            throw new IllegalArgumentException("A node cannot be used to model a public transport way");
        }
    }

    public List<Way> getWays() {
        return this.ways;
    }
}

