/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pbf.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmExporter;
import org.openstreetmap.josm.plugins.pbf.PbfConstants;
import org.openstreetmap.josm.plugins.pbf.io.PbfWriter;

public class PbfExporter
extends OsmExporter {
    public PbfExporter() {
        super(PbfConstants.FILE_FILTER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSave(File file, OsmDataLayer layer) throws IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                try (PbfWriter w = new PbfWriter(out);){
                    layer.data.getReadLock().lock();
                    try {
                        w.writeLayer(layer);
                    }
                    finally {
                        layer.data.getReadLock().unlock();
                    }
                }
                if (out == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (out == null) throw throwable;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

