/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary;

import com.google.protobuf.ByteString;
import crosby.binary.Osmformat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class StringTable {
    private HashMap<String, Integer> counts;
    private HashMap<String, Integer> stringmap;
    private String[] set;

    public StringTable() {
        this.clear();
    }

    public void incr(String s) {
        if (this.counts.containsKey(s)) {
            this.counts.put(s, new Integer(this.counts.get(s) + 1));
        } else {
            this.counts.put(s, new Integer(1));
        }
    }

    public int getIndex(String s) {
        return this.stringmap.get(s);
    }

    public void finish() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int diff = (Integer)StringTable.this.counts.get(s2) - (Integer)StringTable.this.counts.get(s1);
                return diff;
            }
        };
        this.set = this.counts.keySet().toArray(new String[0]);
        if (this.set.length > 0) {
            Arrays.sort(this.set, comparator);
            Arrays.sort(this.set, Math.min(128, this.set.length - 1), Math.min(16384, this.set.length - 1));
            Arrays.sort(this.set, Math.min(16384, this.set.length - 1), Math.min(0x200000, this.set.length - 1), comparator);
        }
        this.stringmap = new HashMap(2 * this.set.length);
        int i = 0;
        while (i < this.set.length) {
            this.stringmap.put(this.set[i], new Integer(i + 1));
            ++i;
        }
        this.counts = null;
    }

    public void clear() {
        this.counts = new HashMap(100);
        this.stringmap = null;
        this.set = null;
    }

    public Osmformat.StringTable.Builder serialize() {
        Osmformat.StringTable.Builder builder = Osmformat.StringTable.newBuilder();
        builder.addS(ByteString.copyFromUtf8(""));
        int i = 0;
        while (i < this.set.length) {
            builder.addS(ByteString.copyFromUtf8(this.set[i]));
            ++i;
        }
        return builder;
    }
}

