/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import org.apache.poi.ss.format.CellDateFormatter;
import org.apache.poi.ss.format.CellElapsedFormatter;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.ss.format.CellNumberFormatter;
import org.apache.poi.ss.format.CellTextFormatter;

public enum CellFormatType {
    NUMBER{

        @Override
        boolean isSpecial(char c) {
            return false;
        }

        @Override
        CellFormatter formatter(String string) {
            return new CellNumberFormatter(string);
        }
    }
    ,
    DATE{

        @Override
        boolean isSpecial(char c) {
            return c == '\'' || c <= '\u007f' && Character.isLetter(c);
        }

        @Override
        CellFormatter formatter(String string) {
            return new CellDateFormatter(string);
        }
    }
    ,
    ELAPSED{

        @Override
        boolean isSpecial(char c) {
            return false;
        }

        @Override
        CellFormatter formatter(String string) {
            return new CellElapsedFormatter(string);
        }
    }
    ,
    TEXT{

        @Override
        boolean isSpecial(char c) {
            return false;
        }

        @Override
        CellFormatter formatter(String string) {
            return new CellTextFormatter(string);
        }
    };


    abstract boolean isSpecial(char var1);

    abstract CellFormatter formatter(String var1);
}

