/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import javax.swing.JMenu;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImportImageFileImporter;
import org.openstreetmap.josm.plugins.ImportImagePlugin.LoadImageAction;
import org.openstreetmap.josm.plugins.ImportImagePlugin.PluginOperations;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;

public class ImportImagePlugin
extends Plugin {
    private static Logger logger;
    JMenu mainmenu = null;
    JosmAction loadFileAction = null;
    static ClassLoader pluginClassLoader;
    static Properties pluginProps;
    static final String PLUGIN_DIR;
    static final String PLUGINPROPERTIES_PATH;
    static final String PLUGINLIBRARIES_DIR;
    static final String PLUGINPROPERTIES_FILENAME = "pluginProperties.properties";
    static final String LOGGING_PROPERTIES_FILEPATH;

    public Properties getPluginProps() {
        return pluginProps;
    }

    public ImportImagePlugin(PluginInformation info) throws IOException {
        super(info);
        try {
            pluginClassLoader = this.createPluginClassLoader();
            this.initializeLogger(pluginClassLoader);
            this.checkInstallation();
            if (pluginProps == null || pluginProps.isEmpty()) {
                pluginProps = new Properties();
                pluginProps.load(new File(PLUGINPROPERTIES_PATH).toURI().toURL().openStream());
                logger.debug((Object)"Plugin properties loaded");
            }
            PluginOperations.loadCRSData(pluginProps);
            this.loadFileAction = new LoadImageAction();
            this.loadFileAction.setEnabled(true);
            if (Main.main != null) {
                MainMenu.add((JMenu)Main.main.menu.imagerySubMenu, (JosmAction)this.loadFileAction);
            }
            ExtensionFileFilter.addImporter((FileImporter)new ImportImageFileImporter());
        }
        catch (IOException e) {
            logger.fatal((Object)"Error while loading plugin", (Throwable)e);
            throw e;
        }
        logger.info((Object)"Plugin successfully loaded.");
    }

    private void checkInstallation() throws IOException {
        boolean isInstalled = true;
        if (!(new File(PLUGINPROPERTIES_PATH).exists() && new File(PLUGIN_DIR).exists() && new File(PLUGINLIBRARIES_DIR).exists())) {
            isInstalled = false;
        }
        if (!isInstalled) {
            URL propertiesURL;
            Throwable throwable;
            FileWriter fw;
            File libDir;
            File pluginDir = new File(PLUGIN_DIR);
            if (!pluginDir.exists()) {
                pluginDir.mkdir();
            }
            if (!(libDir = new File(PLUGINLIBRARIES_DIR)).exists()) {
                libDir.mkdir();
            }
            if (pluginProps == null || pluginProps.isEmpty()) {
                fw = new FileWriter(new File(PLUGINPROPERTIES_PATH));
                throwable = null;
                try {
                    propertiesURL = pluginClassLoader.getResource("resources/pluginProperties.properties");
                    pluginProps = new Properties();
                    pluginProps.load(propertiesURL.openStream());
                    pluginProps.store(fw, null);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (fw != null) {
                        if (throwable != null) {
                            try {
                                fw.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            fw.close();
                        }
                    }
                }
                logger.debug((Object)"Plugin properties loaded");
            }
            if (!new File(LOGGING_PROPERTIES_FILEPATH).exists()) {
                fw = new FileWriter(new File(LOGGING_PROPERTIES_FILEPATH));
                throwable = null;
                try {
                    propertiesURL = pluginClassLoader.getResource("resources/log4j.properties");
                    Properties loggingProps = new Properties();
                    loggingProps.load(propertiesURL.openStream());
                    loggingProps.store(fw, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fw != null) {
                        if (throwable != null) {
                            try {
                                fw.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            fw.close();
                        }
                    }
                }
                logger.debug((Object)"Logging properties created");
            }
            logger.debug((Object)"Plugin successfully installed");
        }
    }

    private void initializeLogger(ClassLoader cl) {
        Properties props = new Properties();
        try {
            props.load(new File(LOGGING_PROPERTIES_FILEPATH).toURI().toURL().openStream());
            props.setProperty("log4j.appender.MyRoFiAppender.file", Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/" + "log.log");
            PropertyConfigurator.configure((Properties)props);
            logger = Logger.getLogger(ImportImagePlugin.class);
            logger.info((Object)"Logger successfully initialized.");
            return;
        }
        catch (IOException e) {
            System.out.println("Logging properties file not found. Using standard settings.");
            props.setProperty("log4j.rootLogger", "INFO, A");
            props.setProperty("log4j.appender.A", "org.apache.log4j.FileAppender");
            props.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout ");
            props.setProperty("log4j.appender.A.layout.ConversionPattern", "%d{ISO8601} %-5p [%t] %c: %m%n");
            props.setProperty("log4j.appender.A.file", Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/" + "log.log");
            PropertyConfigurator.configure((Properties)props);
            logger = Logger.getLogger(ImportImagePlugin.class);
            logger.info((Object)"Logger successfully initialized with standard settings.");
            return;
        }
    }

    private ClassLoader createPluginClassLoader() throws MalformedURLException {
        URLClassLoader loader = null;
        loader = URLClassLoader.newInstance(new URL[]{new File(Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin.jar").toURI().toURL()}, ImportImagePlugin.class.getClassLoader());
        return loader;
    }

    static {
        PLUGIN_DIR = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/";
        PLUGINPROPERTIES_PATH = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/pluginProperties.properties";
        PLUGINLIBRARIES_DIR = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/lib/";
        LOGGING_PROPERTIES_FILEPATH = Main.pref.getPluginsDirectory().getAbsolutePath() + "/ImportImagePlugin/log4j.properties/";
    }
}

