/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;

public class RouteChecker {
    private final Test test;
    private Relation relation;
    private ArrayList<TestError> errors = new ArrayList();
    private boolean hasGap;
    List<RelationMember> sortedMembers;

    public RouteChecker(Relation r, Test t) {
        this.test = t;
        this.relation = r;
        this.hasGap = false;
        this.performSortingTest();
    }

    private void performSortingTest() {
        ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
        for (RelationMember rm : this.relation.getMembers()) {
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            waysToCheck.add(rm);
        }
        if (waysToCheck.isEmpty()) {
            return;
        }
        if (this.hasGap(waysToCheck)) {
            this.hasGap = true;
            RelationSorter sorter = new RelationSorter();
            this.sortedMembers = sorter.sortMembers(waysToCheck);
            if (!this.hasGap(this.sortedMembers)) {
                TestError e = new TestError(this.test, Severity.WARNING, I18n.tr((String)"PT: Route contains a gap that can be fixed by sorting", (Object[])new Object[0]), 3711, (OsmPrimitive)this.relation);
                this.errors.add(e);
            }
        }
    }

    private boolean hasGap(List<RelationMember> waysToCheck) {
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(waysToCheck);
        for (int i = 0; i < links.size(); ++i) {
            boolean hasError;
            WayConnectionType link = (WayConnectionType)links.get(i);
            boolean bl = hasError = i != 0 && !link.linkPrev || i != links.size() - 1 && !link.linkNext || link.direction == null || WayConnectionType.Direction.NONE.equals((Object)link.direction);
            if (!hasError) continue;
            return true;
        }
        return false;
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public List<RelationMember> getSortedMembers() {
        return this.sortedMembers;
    }

    public boolean getHasGap() {
        return this.hasGap;
    }
}

