/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.gui;

import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.tools.I18n;

public class IncompleteMembersDownloadDialog
extends JPanel {
    private static final long serialVersionUID = -4275151182361040329L;
    private static ASK_TO_FETCH askToFetch = ASK_TO_FETCH.DO_ASK;
    private long relationId;
    String message;
    private JCheckBox checkbox;
    private String[] options;
    private int selectedOption;

    public IncompleteMembersDownloadDialog(long id) {
        this.relationId = id;
        this.selectedOption = Integer.MIN_VALUE;
        this.message = I18n.tr((String)("The relation (id=" + this.relationId + ") has incomplete members.\nThey need to be downloaded to proceed with validation of this relation.\nDo you want to download incomplete members?"), (Object[])new Object[0]);
        this.checkbox = new JCheckBox(I18n.tr((String)"Remember my choice and don't ask me again in this session", (Object[])new Object[0]));
        this.options = new String[2];
        this.options[0] = I18n.tr((String)"Yes", (Object[])new Object[0]);
        this.options[1] = I18n.tr((String)"No", (Object[])new Object[0]);
    }

    public int getUserSelection() {
        if (askToFetch == ASK_TO_FETCH.DONT_ASK_AND_FETCH) {
            return 0;
        }
        if (askToFetch == ASK_TO_FETCH.DONT_ASK_AND_DONT_FETCH) {
            return 1;
        }
        Object[] params = new Object[]{this.message, this.checkbox};
        this.selectedOption = JOptionPane.showOptionDialog(this, params, I18n.tr((String)"Fetch Request", (Object[])new Object[0]), 0, 3, null, this.options, 0);
        if (this.checkbox.isSelected()) {
            askToFetch = this.selectedOption == 0 ? ASK_TO_FETCH.DONT_ASK_AND_FETCH : ASK_TO_FETCH.DONT_ASK_AND_DONT_FETCH;
        }
        return this.selectedOption;
    }

    private void createDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object[] params = new Object[]{this.message, this.checkbox};
            this.selectedOption = JOptionPane.showOptionDialog(null, params, I18n.tr((String)"Fetch Request", (Object[])new Object[0]), 0, 3, null, this.options, 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IncompleteMembersDownloadDialog.this.createDialog();
                }
            });
        }
    }

    private static enum ASK_TO_FETCH {
        DO_ASK,
        DONT_ASK_AND_FETCH,
        DONT_ASK_AND_DONT_FETCH;

    }
}

