/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.actions.IncompleteMembersDownloadThread;
import org.openstreetmap.josm.plugins.pt_assistant.gui.IncompleteMembersDownloadDialog;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.RouteChecker;
import org.openstreetmap.josm.plugins.pt_assistant.validation.WayChecker;
import org.openstreetmap.josm.tools.I18n;

public class PTAssitantValidatorTest
extends Test {
    public static final int ERROR_CODE_SORTING = 3711;
    public static final int ERROR_CODE_ROAD_TYPE = 3721;
    public static final int ERROR_CODE_DIRECTION = 3731;

    public PTAssitantValidatorTest() {
        super(I18n.tr((String)"Public Transport Assistant tests", (Object[])new Object[0]), I18n.tr((String)"Check if route relations are compatible with public transport version 2", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        boolean downloadSuccessful;
        if (!RouteUtils.isTwoDirectionRoute(r)) {
            return;
        }
        if (r.hasIncompleteMembers() && !(downloadSuccessful = this.downloadIncompleteMembers(r))) {
            return;
        }
        WayChecker wayChecker = new WayChecker(r, this);
        this.errors.addAll(wayChecker.getErrors());
        RouteChecker routeChecker = new RouteChecker(r, this);
        this.errors.addAll(routeChecker.getErrors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadIncompleteMembers(Relation r) {
        IncompleteMembersDownloadDialog incompleteMembersDownloadDialog = new IncompleteMembersDownloadDialog(r.getId());
        int userInput = incompleteMembersDownloadDialog.getUserSelection();
        if (userInput == 0) {
            IncompleteMembersDownloadThread t = new IncompleteMembersDownloadThread(r);
            t.start();
            IncompleteMembersDownloadThread incompleteMembersDownloadThread = t;
            synchronized (incompleteMembersDownloadThread) {
                try {
                    t.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }

    private void performDummyTest(Relation r) {
        ArrayList<Relation> primitives = new ArrayList<Relation>(1);
        primitives.add(r);
        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: dummy test warning", (Object[])new Object[0]), 3731, primitives));
    }
}

