/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BRoad;
import org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes.BuildTurnLanes;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.TagEditor;
import org.openstreetmap.josm.plugins.turnlanestagging.editor.ac.KeyValuePair;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsData;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsTableModel;
import org.openstreetmap.josm.plugins.turnlanestagging.util.Util;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagEditorDialog
extends JDialog {
    private static TagEditorDialog instance = null;
    public static final Dimension PREFERRED_SIZE = new Dimension(750, 700);
    private TagEditor tagEditor = null;
    private BuildTurnLanes buildTurnLanes = null;
    private JButton jbOk = null;
    private OKAction okAction = null;
    private CancelAction cancelAction = null;
    List<BRoad> lastEdits = new ArrayList<BRoad>();

    protected TagEditorDialog() {
        this.build();
    }

    public static TagEditorDialog getInstance() {
        if (instance == null) {
            instance = new TagEditorDialog();
        }
        return instance;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setModal(false);
        this.setSize(PREFERRED_SIZE);
        this.setTitle(I18n.tr((String)"Turn Lanes Editor", (Object[])new Object[0]));
        this.setAlwaysOnTop(true);
        JPanel pnlPresetGrid = this.buildPresetGridPanel();
        pnlPresetGrid.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel pnlTagGrid = this.buildTagGridPanel();
        JSplitPane splitPane = new JSplitPane(0, pnlPresetGrid, pnlTagGrid);
        this.setMinimumSize(new Dimension(750, 500));
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(400);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)this.buildButtonRowPanel(), "South");
        this.getRootPane().registerKeyboardAction(this.cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected JPanel buildButtonRowPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        this.okAction = new OKAction();
        this.jbOk = new JButton(this.okAction);
        pnl.add(this.jbOk);
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this.okAction);
        this.cancelAction = new CancelAction();
        pnl.add(new JButton(this.cancelAction));
        return pnl;
    }

    protected JPanel buildTagGridPanel() {
        this.tagEditor = new TagEditor();
        return this.tagEditor;
    }

    public TagEditorModel getModel() {
        return this.tagEditor.getModel();
    }

    protected JPanel buildPresetGridPanel() {
        this.buildTurnLanes = new BuildTurnLanes();
        this.buildTurnLanes.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("RoadChanged")) {
                    TagEditorDialog.this.addTagOnRoad((BRoad)evt.getNewValue());
                    TagEditorDialog.this.jbOk.requestFocus();
                }
            }
        });
        return this.buildTurnLanes;
    }

    public PresetsTableModel getPressetTableModel() {
        return this.buildTurnLanes.getModel();
    }

    public void startEditSession() {
        this.tagEditor.getModel().clearAppliedPresets();
        this.tagEditor.getModel().initFromJOSMSelection();
        this.getModel().ensureOneTag();
        this.setRoadProperties();
    }

    public boolean addOneway() {
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        for (OsmPrimitive element : selection) {
            if (!element.hasDirectionKeys()) continue;
            return true;
        }
        return false;
    }

    public void setRoadProperties() {
        PresetsData presetsData = new PresetsData();
        BRoad bRoad = new BRoad();
        bRoad.setName("Unidirectional");
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        for (OsmPrimitive element : selection) {
            for (String key : element.keySet()) {
                if (key.equals("turn:lanes")) {
                    bRoad.getLanesUnid().setStringLanes("unid", element.get(key));
                    bRoad.setName("Unidirectional");
                    if (element.hasKey("lanes") && Util.isInt(element.get("lanes")) && Integer.valueOf(element.get("lanes")).intValue() != bRoad.getLanesUnid().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                } else if (key.equals("lanes") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes") && element.hasDirectionKeys()) {
                    bRoad = presetsData.defaultRoadUnidirectional(Integer.valueOf(element.get(key)));
                    bRoad.setName("Unidirectional");
                } else if (!(!key.equals("lanes") || !Util.isInt(element.get(key)) || element.hasKey("turn:lanes") || element.hasKey("turn:lanes:forward") || element.hasKey("turn:lanes:both_ways") || element.hasKey("turn:lanes:backward") || element.hasKey("lanes:forward") || element.hasKey("lanes:both_ways") || element.hasKey("lanes:backward"))) {
                    bRoad = presetsData.defaultRoadUnidirectional(Integer.valueOf(element.get(key)));
                    bRoad.setName("Unidirectional");
                } else if (key.equals("turn:lanes:forward")) {
                    bRoad.getLanesA().setStringLanes("forward", element.get(key));
                    bRoad.getLanesA().setType("forward");
                    bRoad.setName("Bidirectional");
                    if (element.hasKey("lanes:forward") && Util.isInt(element.get("lanes:forward")) && Integer.valueOf(element.get("lanes:forward")).intValue() != bRoad.getLanesA().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes:forward has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                } else if (key.equals("turn:lanes:both_ways")) {
                    bRoad.getLanesB().setStringLanes("both_ways", element.get(key));
                    bRoad.getLanesB().setType("both_ways");
                    bRoad.setName("Bidirectional");
                    if (element.hasKey("lanes:both_ways") && Util.isInt(element.get("lanes:both_ways")) && Integer.valueOf(element.get("lanes:both_ways")).intValue() != bRoad.getLanesB().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes:both_ways has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                } else if (key.equals("turn:lanes:backward")) {
                    bRoad.getLanesC().setStringLanes("backward", element.get(key));
                    bRoad.getLanesC().setType("backward");
                    bRoad.setName("Bidirectional");
                    if (element.hasKey("lanes:backward") && Util.isInt(element.get("lanes:backward")) && Integer.valueOf(element.get("lanes:backward")).intValue() != bRoad.getLanesC().getLanes().size()) {
                        new Notification(I18n.tr((String)" The number of lanes:backward has fixed according number of turns", (Object[])new Object[0])).show();
                    }
                } else if (key.equals("lanes:forward") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes:forward")) {
                    bRoad.setLanesA(presetsData.defaultLanes("forward", Integer.valueOf(element.get(key))));
                    bRoad.getLanesA().setType("forward");
                    bRoad.setName("Bidirectional");
                } else if (key.equals("lanes:both_ways") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes:both_ways")) {
                    bRoad.setLanesB(presetsData.defaultLanes("both_ways", Integer.valueOf(element.get(key))));
                    bRoad.getLanesB().setType("both_ways");
                    bRoad.setName("Bidirectional");
                } else if (key.equals("lanes:backward") && Util.isInt(element.get(key)) && !element.hasKey("turn:lanes:backward")) {
                    bRoad.setLanesC(presetsData.defaultLanes("backward", Integer.valueOf(element.get(key))));
                    bRoad.getLanesC().setType("backward");
                    bRoad.setName("Bidirectional");
                }
                if (!key.equals("oneway") || !element.get(key).equals("-1")) continue;
                new Notification(I18n.tr((String)"check the right direction of the way", (Object[])new Object[0])).show();
            }
        }
        if (bRoad.getName().equals("Unidirectional")) {
            if (bRoad.getLanesUnid().getLanes().size() > 0) {
                this.buildTurnLanes.setLanesByRoadUnidirectional(bRoad);
            } else {
                this.buildTurnLanes.setLastEdit();
            }
        } else if (bRoad.getLanesA().getLanes().size() > 0 || bRoad.getLanesB().getLanes().size() > 0 || bRoad.getLanesC().getLanes().size() > 0) {
            if (bRoad.getLanesA().getLanes().isEmpty()) {
                bRoad.setLanesA(presetsData.defaultLanes("forward", 1));
            }
            if (bRoad.getLanesC().getLanes().isEmpty()) {
                bRoad.setLanesC(presetsData.defaultLanes("backward", 1));
            }
            this.buildTurnLanes.setLanesByRoadBidirectional(bRoad);
        } else {
            this.buildTurnLanes.setLastEdit();
        }
    }

    public void addTagOnRoad(BRoad bRoad) {
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes", null));
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes", null));
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:forward", null));
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:forward", null));
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:both_ways", null));
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:both_ways", null));
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:backward", null));
        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:backward", null));
        if (bRoad.getName().equals("Unidirectional")) {
            if (this.isEmptyturnlane(bRoad.getLanesUnid().getTagturns())) {
                this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes", bRoad.getLanesUnid().getTagturns()));
            }
            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes", String.valueOf(bRoad.getLanesUnid().getLanes().size())));
        } else {
            if (!bRoad.getLanesA().getLanes().isEmpty()) {
                if (bRoad.getLanesA().getType().equals("forward")) {
                    if (this.isEmptyturnlane(bRoad.getLanesA().getTagturns())) {
                        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:forward", bRoad.getLanesA().getTagturns()));
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:forward", String.valueOf(bRoad.getLanesA().getLanes().size())));
                } else {
                    if (this.isEmptyturnlane(bRoad.getLanesA().getTagturns())) {
                        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:backward", bRoad.getLanesA().getTagturns()));
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:backward", String.valueOf(bRoad.getLanesA().getLanes().size())));
                }
            }
            if (!bRoad.getLanesB().getLanes().isEmpty()) {
                if (this.isEmptyturnlane(bRoad.getLanesB().getTagturns())) {
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:both_ways", bRoad.getLanesB().getTagturns()));
                }
                this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:both_ways", String.valueOf(bRoad.getLanesB().getLanes().size())));
            }
            if (!bRoad.getLanesC().getLanes().isEmpty()) {
                if (bRoad.getLanesC().getType().equals("backward")) {
                    if (this.isEmptyturnlane(bRoad.getLanesC().getTagturns())) {
                        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:backward", bRoad.getLanesC().getTagturns()));
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:backward", String.valueOf(bRoad.getLanesC().getLanes().size())));
                } else {
                    if (this.isEmptyturnlane(bRoad.getLanesC().getTagturns())) {
                        this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("turn:lanes:forward", bRoad.getLanesC().getTagturns()));
                    }
                    this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes:forward", String.valueOf(bRoad.getLanesC().getLanes().size())));
                }
            }
            this.tagEditor.getModel().applyKeyValuePair(new KeyValuePair("lanes", String.valueOf(bRoad.getNumLanesBidirectional())));
        }
        this.tagEditor.repaint();
    }

    public boolean isEmptyturnlane(String turns) {
        List<String> turnsList = Arrays.asList("reverse", "sharp_left", "left", "slight_left", "merge_to_right", "through", "reversible", "merge_to_left", "slight_right", "right", "sharp_right");
        for (String tl : turnsList) {
            if (!turns.contains(tl)) continue;
            return true;
        }
        return false;
    }

    class OKAction
    extends AbstractAction
    implements PropertyChangeListener {
        public OKAction() {
            this.putValue("Name", I18n.tr((String)"OK", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.putValue("ShortDescription", I18n.tr((String)"Apply edited tags and close dialog", (Object[])new Object[0]));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl ENTER"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
            TagEditorDialog.this.buildTurnLanes.addLastEditInTable();
            TagEditorDialog.this.buildTurnLanes.clearSelection();
        }

        public void run() {
            TagEditorDialog.this.tagEditor.stopEditing();
            TagEditorDialog.this.setVisible(false);
            TagEditorDialog.this.tagEditor.getModel().updateJOSMSelection();
            DataSet ds = Main.main.getCurrentDataSet();
            ds.fireSelectionChanged();
            Main.parent.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(TagEditorModel.PROP_DIRTY)) {
                return;
            }
            if (!evt.getNewValue().getClass().equals(Boolean.class)) {
                return;
            }
            this.setEnabled(true);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr((String)"Cancel", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
            this.putValue("ShortDescription", I18n.tr((String)"Abort tag editing and close dialog", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            TagEditorDialog.this.setVisible(false);
        }
    }
}

