/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AddPresetAction
extends JosmAction
implements SelectionChangedListener {
    private String turnslanes;
    private Integer numLanes;

    public AddPresetAction(Integer numLanes, String turnslanes, Integer numKey) {
        super(ExpressionFactory.Functions.tr((String[])new String[]{turnslanes}), null, ExpressionFactory.Functions.tr((String[])new String[]{turnslanes}), Shortcut.registerShortcut((String)("turnlanetag:(" + numLanes + ") " + turnslanes), (String)ExpressionFactory.Functions.tr((String[])new String[]{"turnlanetag:(" + numLanes + ") " + turnslanes}), (int)numKey, (int)5010), true);
        this.turnslanes = turnslanes;
        this.numLanes = numLanes;
        DataSet.addSelectionListener((SelectionChangedListener)this);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.addTurnLanesTag();
        Main.main.undoRedo.add((Command)new SequenceCommand(ExpressionFactory.Functions.tr((String[])new String[]{"revert tags"}), new Command[]{this.addTurnLanesTag()}));
    }

    protected Command addTurnLanesTag() {
        ArrayList<ChangePropertyCommand> commands = new ArrayList<ChangePropertyCommand>();
        LinkedList ways = new LinkedList(Main.main.getCurrentDataSet().getSelectedWays());
        if (ways.size() == 1) {
            commands.add(new ChangePropertyCommand(ways, "lanes", this.getNumLanes().toString()));
            commands.add(new ChangePropertyCommand(ways, "turn:lanes", this.getTurnslanes()));
        }
        if (!commands.isEmpty()) {
            String title1 = I18n.trn((String)"Pasting {0} tag", (String)"Pasting {0} tags", (long)2L, (Object[])new Object[]{2});
            String title2 = I18n.trn((String)"to {0} primitive", (String)"to {0} primtives", (long)2L, (Object[])new Object[]{2});
            return new SequenceCommand(title1 + " " + title2, commands);
        }
        return null;
    }

    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        this.setEnabled(newSelection != null && newSelection.size() > 0 && this.isRoad());
    }

    public boolean isRoad() {
        Collection selection = Main.main.getCurrentDataSet().getSelected();
        for (OsmPrimitive element : selection) {
            for (String key : element.keySet()) {
                if (!key.equals("highway")) continue;
                return true;
            }
        }
        return false;
    }

    public String getTurnslanes() {
        return this.turnslanes;
    }

    public void setTurnslanes(String turnslanes) {
        this.turnslanes = turnslanes;
    }

    public Integer getNumLanes() {
        return this.numLanes;
    }

    public void setNumLanes(Integer numLanes) {
        this.numLanes = numLanes;
    }
}

