/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.actions.IncompleteMembersDownloadThread;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;

public class PTAssitantValidatorTest
extends Test {
    public static final int ERROR_CODE_DIRECTION = 3731;

    public PTAssitantValidatorTest() {
        super(I18n.tr((String)"Public Transport Assistant tests", (Object[])new Object[0]), I18n.tr((String)"Check if route relations are compatible with public transport version 2", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Relation r) {
        if (!RouteUtils.isTwoDirectionRoute(r)) {
            return;
        }
        if (r.hasIncompleteMembers()) {
            String message = I18n.tr((String)("The relation (id=" + r.getId() + ") has incomplete members.\nThey need to be downloaded to proceed with validation of this relation.\nDo you want to download incomplete members?"), (Object[])new Object[0]);
            JCheckBox checkbox = new JCheckBox(I18n.tr((String)"Remember my choice and don't ask me again in this session", (Object[])new Object[0]));
            Object[] params = new Object[]{message, checkbox};
            Object[] options = new String[]{I18n.tr((String)"Yes", (Object[])new Object[0]), I18n.tr((String)"No", (Object[])new Object[0])};
            int userInput = Integer.MIN_VALUE;
            userInput = JOptionPane.showOptionDialog(null, params, I18n.tr((String)"Fetch Request", (Object[])new Object[0]), 0, 3, null, options, 0);
            if (userInput == 0) {
                IncompleteMembersDownloadThread t = new IncompleteMembersDownloadThread(r);
                t.start();
                IncompleteMembersDownloadThread incompleteMembersDownloadThread = t;
                synchronized (incompleteMembersDownloadThread) {
                    try {
                        t.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
        ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
        for (RelationMember rm : r.getMembers()) {
            if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
            waysToCheck.add(rm);
        }
        if (waysToCheck.isEmpty()) {
            return;
        }
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(waysToCheck);
        for (int i = 0; i < links.size(); ++i) {
            if ((!OsmUtils.isTrue((String)((RelationMember)waysToCheck.get(i)).getWay().get("oneway")) || !((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.BACKWARD)) && (!OsmUtils.isReversed((String)((RelationMember)waysToCheck.get(i)).getWay().get("oneway")) || !((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.FORWARD)) || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway", "lane") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("oneway:bus", "no") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway", "opposite_lane") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("oneway:psv", "no") || ((RelationMember)waysToCheck.get(i)).getWay().hasTag("trolley_wire", "backward")) continue;
            ArrayList<Relation> primitives = new ArrayList<Relation>(1);
            primitives.add(r);
            ArrayList<Way> highlighted = new ArrayList<Way>(1);
            highlighted.add(((RelationMember)waysToCheck.get(i)).getWay());
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route passes a oneway road in wrong direction", (Object[])new Object[0]), 3731, primitives, highlighted));
            return;
        }
    }

    public boolean isFixable(TestError testError) {
        return false;
    }

    public Command fixError(TestError testError) {
        return null;
    }
}

