/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.pt_assistant.utils.IncompleteMembersDownloader;
import org.openstreetmap.josm.tools.I18n;

public class RouteUtils {
    private static ASK_TO_FETCH askToFetch = ASK_TO_FETCH.DO_ASK;
    private static Relation lastRelationToFetch = null;

    private RouteUtils() {
    }

    public static boolean isTwoDirectionRoute(Relation r) {
        if (!r.hasKey("route") || !r.hasTag("public_transport:version", "2")) {
            return false;
        }
        return r.hasTag("route", "bus") || r.hasTag("route", "trolleybus") || r.hasTag("route", "share_taxi") || r.hasTag("route", "tram") || r.hasTag("route", "light_rail") || r.hasTag("route", "subway") || r.hasTag("route", "train");
    }

    public static boolean isPTStop(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
            return true;
        }
        if (rm.getType().equals((Object)OsmPrimitiveType.RELATION)) {
            return rm.getRole().equals("stop_area");
        }
        Way w = rm.getWay();
        return w.hasTag("public_transport", "platform") || w.hasTag("highway", "platform") || w.hasTag("railway", "platform") || w.hasTag("public_transport", "platform_entry_only") || w.hasTag("highway", "platform_entry_only") || w.hasTag("railway", "platform_entry_only") || w.hasTag("public_transport", "platform_exit_only") || w.hasTag("highway", "platform_exit_only") || w.hasTag("railway", "platform_exit_only");
    }

    public static boolean isPTWay(RelationMember rm) {
        return !RouteUtils.isPTStop(rm);
    }

    public static boolean isWaySuitableForBuses(Way way) {
        return way.hasTag("highway", "motorway") || way.hasTag("highway", "trunk") || way.hasTag("highway", "primary") || way.hasTag("highway", "secondary") || way.hasTag("highway", "tertiary") || way.hasTag("highway", "unclassified") || way.hasTag("highway", "road") || way.hasTag("highway", "residential") || way.hasTag("highway", "service") || way.hasTag("highway", "motorway_link") || way.hasTag("highway", "trunk_link") || way.hasTag("highway", "primary_link") || way.hasTag("highway", "secondary_link") || way.hasTag("highway", "tertiary_link") || way.hasTag("highway", "living_street") || way.hasTag("highway", "bus_guideway") || way.hasTag("highway", "road") || way.hasTag("cycleway", "share_busway") || way.hasTag("cycleway", "shared_lane");
    }

    public static boolean ensureMemberCompleteness(Relation r) {
        if (r == null) {
            return false;
        }
        boolean isComplete = true;
        for (RelationMember rm : r.getMembers()) {
            if (!(rm.isNode() && rm.getNode().isIncomplete() || rm.isWay() && rm.getWay().isIncomplete()) && (!rm.isRelation() || !rm.getRelation().isIncomplete())) continue;
            isComplete = false;
            break;
        }
        if (!isComplete && !r.equals((Object)lastRelationToFetch)) {
            int userInput = Integer.MIN_VALUE;
            if (askToFetch == ASK_TO_FETCH.DO_ASK) {
                String message = I18n.tr((String)("The relation (id=" + r.getId() + ") has incomplete members.\nThey need to be downloaded to proceed with validation of this relation.\nDo you want to download incomplete members?"), (Object[])new Object[0]);
                JCheckBox checkbox = new JCheckBox(I18n.tr((String)"Remember my choice and don't ask me again in this session", (Object[])new Object[0]));
                Object[] params = new Object[]{message, checkbox};
                Object[] options = new String[]{I18n.tr((String)"Yes", (Object[])new Object[0]), I18n.tr((String)"No", (Object[])new Object[0])};
                userInput = JOptionPane.showOptionDialog(null, params, I18n.tr((String)"Fetch Request", (Object[])new Object[0]), 0, 3, null, options, 0);
                if (checkbox.isSelected()) {
                    askToFetch = userInput == 0 ? ASK_TO_FETCH.DONT_ASK_AND_FETCH : ASK_TO_FETCH.DONT_ASK_AND_DONT_FETCH;
                }
            }
            if (userInput == 0 || askToFetch == ASK_TO_FETCH.DONT_ASK_AND_FETCH) {
                ArrayList<PrimitiveId> list = new ArrayList<PrimitiveId>();
                for (OsmPrimitive primitive : r.getIncompleteMembers()) {
                    list.add((PrimitiveId)primitive);
                }
                Thread t = new Thread(new IncompleteMembersDownloader(list));
                t.run();
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                JOptionPane.showMessageDialog(null, "download expected to be finished");
                isComplete = true;
                lastRelationToFetch = r;
            }
        }
        return isComplete;
    }

    public static boolean hasIncompleteMembers(Relation r) {
        if (r == null) {
            return true;
        }
        for (RelationMember rm : r.getMembers()) {
            if (!(rm.isNode() && rm.getNode().isIncomplete() || rm.isWay() && rm.getWay().isIncomplete()) && (!rm.isRelation() || !rm.getRelation().isIncomplete())) continue;
            return true;
        }
        return false;
    }

    private static enum ASK_TO_FETCH {
        DO_ASK,
        DONT_ASK_AND_FETCH,
        DONT_ASK_AND_DONT_FETCH;

    }
}

