/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BLane;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BLanes;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BRoad;
import org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes.TurnSelection;
import org.openstreetmap.josm.plugins.turnlanestagging.preset.PresetsData;
import org.openstreetmap.josm.plugins.turnlanestagging.util.Util;

public class TurnSelectionUnidirectional
extends JPanel {
    JPanel jpanelcontent = null;
    JPanel jpanelContentLane = null;
    JPanel jpanelcontentTurns = null;
    JPanel jpanelcontentSelections = null;
    JSpinner spinner = null;
    private final JTextField jtfChangeLanes = new JTextField();
    public static final String LINESCHANGED = "LinesChanged";
    boolean clickLanesAction = true;
    BRoad valBRoad = new BRoad();
    PresetsData presetsData = new PresetsData();
    int min = 1;
    int max = 12;
    int step = 1;
    int initValue = 1;
    boolean eventSpiner = true;

    public TurnSelectionUnidirectional() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildselect(), "North");
        this.jpanelContentLane = new JPanel(new GridLayout(1, 1));
        this.jpanelContentLane.setBorder(new SoftBevelBorder(0));
        this.jpanelcontentTurns = new JPanel();
        this.jpanelcontentTurns.setBorder(BorderFactory.createTitledBorder(null, ExpressionFactory.Functions.tr((String[])new String[]{"Lanes"}), 0, 0, null, new Color(102, 102, 102)));
        JScrollPane jsp = new JScrollPane(this.jpanelcontentTurns);
        jsp.setHorizontalScrollBarPolicy(30);
        jsp.setVerticalScrollBarPolicy(21);
        this.jpanelContentLane.add(jsp);
        this.add((Component)this.jpanelContentLane, "Center");
        this.jtfChangeLanes.getDocument().addDocumentListener(new SetLanesChangeListener());
    }

    protected JPanel buildselect() {
        this.jpanelcontentSelections = new JPanel(new GridLayout(1, 2));
        this.jpanelcontentSelections.setBorder(new SoftBevelBorder(0));
        this.spinner = new JSpinner(new SpinnerNumberModel(this.initValue, this.min, this.max, this.step));
        this.jpanelcontentSelections.add(new JLabel(ExpressionFactory.Functions.tr((String[])new String[]{"Number of lanes"})));
        this.jpanelcontentSelections.add(this.spinner);
        this.spinner.addChangeListener(new SPinnerListener());
        return this.jpanelcontentSelections;
    }

    public void lanes(BLanes bLanes) {
        this.jpanelcontentTurns.removeAll();
        this.valBRoad.setName("Unidirectional");
        int numLanes = bLanes.getLanes().size();
        this.jpanelcontentTurns.setLayout(new GridLayout(1, numLanes));
        this.eventSpiner = false;
        this.spinner.setValue(numLanes);
        this.eventSpiner = true;
        this.valBRoad.setLanesUnid(bLanes);
        final List<BLane> listBLines = this.valBRoad.getLanesUnid().getLanes();
        for (int i = 0; i < numLanes; ++i) {
            BLane bLine = listBLines.get(i);
            TurnSelection turnSelection = new TurnSelection(bLine, numLanes);
            turnSelection.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("Left Changed") || evt.getPropertyName().equals("Right Changed") || evt.getPropertyName().equals("Through Changed") || evt.getPropertyName().equals("slight_right Changed") || evt.getPropertyName().equals("slight_left Changed") || evt.getPropertyName().equals("merge_to_right Changed") || evt.getPropertyName().equals("merge_to_left Changed") || evt.getPropertyName().equals("reverse Changed")) {
                        listBLines.add((BLane)evt.getNewValue());
                        TurnSelectionUnidirectional.this.valBRoad.getLanesUnid().setLanes(listBLines);
                        TurnSelectionUnidirectional.this.jtfChangeLanes.setText(TurnSelectionUnidirectional.this.valBRoad.getLanesUnid().getTagturns());
                    }
                }
            });
            this.jpanelcontentTurns.add(turnSelection);
        }
        this.jtfChangeLanes.setText(this.valBRoad.getLanesUnid().getTagturns());
        this.jpanelcontentTurns.revalidate();
        this.jpanelcontentTurns.repaint();
    }

    public void setDefault(BRoad bRoad) {
        this.lanes(bRoad.getLanesUnid());
    }

    public BRoad getValBRoad() {
        return this.valBRoad;
    }

    class SPinnerListener
    implements ChangeListener {
        SPinnerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int lanes = Integer.valueOf(TurnSelectionUnidirectional.this.spinner.getValue().toString());
            TurnSelectionUnidirectional.this.valBRoad.setName("Unidirectional");
            BLanes bLanes = new BLanes("unid");
            if (TurnSelectionUnidirectional.this.eventSpiner) {
                bLanes = lanes >= TurnSelectionUnidirectional.this.valBRoad.getLanesUnid().getLanes().size() ? TurnSelectionUnidirectional.this.presetsData.addLanes((BLanes)Util.clone(TurnSelectionUnidirectional.this.valBRoad.getLanesUnid()), "unid", lanes - TurnSelectionUnidirectional.this.valBRoad.getLanesUnid().getLanes().size()) : TurnSelectionUnidirectional.this.presetsData.removeLanes((BLanes)Util.clone(TurnSelectionUnidirectional.this.valBRoad.getLanesUnid()), TurnSelectionUnidirectional.this.valBRoad.getLanesUnid().getLanes().size() - lanes);
                TurnSelectionUnidirectional.this.lanes(bLanes);
            }
            TurnSelectionUnidirectional.this.eventSpiner = true;
        }
    }

    private class SetLanesChangeListener
    implements DocumentListener {
        private SetLanesChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TurnSelectionUnidirectional.this.firePropertyChange(TurnSelectionUnidirectional.LINESCHANGED, null, TurnSelectionUnidirectional.this.getValBRoad());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

