/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.turnlanestagging.buildturnlanes;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.plugins.turnlanestagging.bean.BLane;
import org.openstreetmap.josm.tools.ImageProvider;

public class TurnSelection
extends JPanel {
    public static final String Left_CHANGED = "Left Changed";
    public static final String Right_CHANGED = "Right Changed";
    public static final String Through_CHANGED = "Through Changed";
    public static final String Reversible_CHANGED = "Reversible Changed";
    public static final String Slight_right_CHANGED = "slight_right Changed";
    public static final String Slight_left_CHANGED = "slight_left Changed";
    public static final String Merge_to_right_CHANGED = "merge_to_right Changed";
    public static final String Merge_to_left_CHANGED = "merge_to_left Changed";
    public static final String Reverse_CHANGED = "reverse Changed";
    private JPanel jPOptions;
    private JCheckBox left;
    private JCheckBox through;
    private JCheckBox reversible;
    private JCheckBox right;
    private JCheckBox slight_right;
    private JCheckBox slight_left;
    private JCheckBox merge_to_right;
    private JCheckBox merge_to_left;
    private JCheckBox reverse;
    BLane bLine;
    int numRoadLanes;
    GridBagConstraints gbc = new GridBagConstraints();

    public TurnSelection(BLane bl, int numRoadLanes) {
        this.bLine = bl;
        this.numRoadLanes = numRoadLanes;
        this.init();
    }

    public void init() {
        this.jPOptions = new JPanel(new GridBagLayout());
        this.left = new JCheckBox();
        this.through = new JCheckBox();
        this.reversible = new JCheckBox();
        this.right = new JCheckBox();
        this.slight_right = new JCheckBox();
        this.slight_left = new JCheckBox();
        this.merge_to_right = new JCheckBox();
        this.merge_to_left = new JCheckBox();
        this.reverse = new JCheckBox();
        this.left.setToolTipText("left");
        this.through.setToolTipText("through");
        this.reversible.setToolTipText("reversible");
        this.right.setToolTipText("right");
        this.slight_right.setToolTipText("slight_right");
        this.slight_left.setToolTipText("slight_left");
        this.merge_to_right.setToolTipText("merge_to_right");
        this.merge_to_left.setToolTipText("merge_to_left");
        this.reverse.setToolTipText("reverse");
        if (this.bLine.getType().equals("unid")) {
            if (this.bLine.getPosition() == 1) {
                this.forwardFirst();
            } else if (this.bLine.getPosition() == this.numRoadLanes) {
                this.forwardLast();
            } else {
                this.forwareMidle();
            }
        }
        if (this.bLine.getType().equals("forward") || this.bLine.getType().equals("backward")) {
            if (this.bLine.getPosition() == 1) {
                if (this.bLine.getType().equals("forward")) {
                    this.forwardFirst();
                }
                if (this.bLine.getType().equals("backward")) {
                    this.backwardFirst();
                }
            } else if (this.bLine.getPosition() == this.numRoadLanes) {
                if (this.bLine.getType().equals("forward")) {
                    this.forwardLast();
                }
                if (this.bLine.getType().equals("backward")) {
                    this.backwardLast();
                }
            } else {
                if (this.bLine.getType().equals("forward")) {
                    this.forwareMidle();
                }
                if (this.bLine.getType().equals("backward")) {
                    this.backwardMidle();
                }
            }
        }
        if (this.bLine.getType().equals("both_ways")) {
            this.both_waysOne();
        }
        this.left.addActionListener(new LeftListener());
        this.right.addActionListener(new RightListener());
        this.through.addActionListener(new ThroughListener());
        this.reversible.addActionListener(new ReversibleListener());
        this.slight_right.addActionListener(new Slight_rightListener());
        this.slight_left.addActionListener(new Slight_leftListener());
        this.merge_to_right.addActionListener(new Merge_to_rightListener());
        this.merge_to_left.addActionListener(new Merge_to_leftListener());
        this.reverse.addActionListener(new ReverseListener());
        this.jPOptions.setBorder(BorderFactory.createTitledBorder(null, "Lane " + this.bLine.getPosition(), 0, 0, null, new Color(102, 102, 102)));
        this.setTurn();
        this.add(this.jPOptions);
    }

    protected void builturn() {
        ArrayList<String> list = new ArrayList<String>();
        boolean status_left = this.left.isSelected();
        boolean status_through = this.through.isSelected();
        boolean status_reversible = this.reversible.isSelected();
        boolean status_right = this.right.isSelected();
        boolean status_slight_right = this.slight_right.isSelected();
        boolean status_slight_left = this.slight_left.isSelected();
        boolean status_merge_to_right = this.merge_to_right.isSelected();
        boolean status_merge_to_left = this.merge_to_left.isSelected();
        boolean status_reverse = this.reverse.isSelected();
        if (status_reverse) {
            list.add("reverse");
        }
        if (status_left) {
            list.add("left");
        }
        if (status_slight_left) {
            list.add("slight_left");
        }
        if (status_merge_to_right) {
            list.add("merge_to_right");
        }
        if (status_through && (this.bLine.getType().equals("forward") || this.bLine.getType().equals("backward") || this.bLine.getType().equals("unid"))) {
            list.add("through");
        }
        if (status_reversible) {
            list.add("reversible");
        }
        if (status_merge_to_left) {
            list.add("merge_to_left");
        }
        if (status_slight_right) {
            list.add("slight_right");
        }
        if (status_right) {
            list.add("right");
        }
        String t = ((Object)list).toString().replace("[", "").replace("]", "").replace(", ", ";");
        this.bLine.setTurn(t);
    }

    protected void setTurn() {
        String[] dirs = this.bLine.getTurn().split("\\;", -1);
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].equals("left")) {
                this.left.setSelected(true);
            }
            if (dirs[i].equals("slight_left")) {
                this.slight_left.setSelected(true);
            }
            if (dirs[i].equals("merge_to_right")) {
                this.merge_to_right.setSelected(true);
            }
            if (dirs[i].equals("through")) {
                this.through.setSelected(true);
            }
            if (dirs[i].equals("merge_to_left")) {
                this.merge_to_left.setSelected(true);
            }
            if (dirs[i].equals("slight_right")) {
                this.slight_right.setSelected(true);
            }
            if (dirs[i].equals("right")) {
                this.right.setSelected(true);
            }
            if (dirs[i].equals("reverse")) {
                this.reverse.setSelected(true);
            }
            if (!dirs[i].equals("reversible")) continue;
            this.reversible.setSelected(true);
        }
    }

    public void forwardFirst() {
        this.slight_left.setIcon(ImageProvider.get((String)"types", (String)"slight_left-forward-off.png"));
        this.slight_right.setIcon(ImageProvider.get((String)"types", (String)"slight_right-forward-off.png"));
        this.left.setIcon(ImageProvider.get((String)"types", (String)"left-forward-off.png"));
        this.through.setIcon(ImageProvider.get((String)"types", (String)"through-forward-off.png"));
        this.right.setIcon(ImageProvider.get((String)"types", (String)"right-forward-off.png"));
        this.merge_to_left.setIcon(ImageProvider.get((String)"types", (String)"merge_to_left-forward-off.png"));
        this.merge_to_right.setIcon(ImageProvider.get((String)"types", (String)"merge_to_right-forward-off.png"));
        this.reverse.setIcon(ImageProvider.get((String)"types", (String)"reverse-forward-off.png"));
        this.slight_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_left-forward.png"));
        this.slight_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_right-forward.png"));
        this.left.setSelectedIcon(ImageProvider.get((String)"types", (String)"left-forward.png"));
        this.through.setSelectedIcon(ImageProvider.get((String)"types", (String)"through-forward.png"));
        this.right.setSelectedIcon(ImageProvider.get((String)"types", (String)"right-forward.png"));
        this.merge_to_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_left-forward.png"));
        this.merge_to_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_right-forward.png"));
        this.reverse.setSelectedIcon(ImageProvider.get((String)"types", (String)"reverse-forward.png"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_left, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.left, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.through, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.right, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_left, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.reverse, this.gbc);
    }

    public void forwardLast() {
        this.slight_left.setIcon(ImageProvider.get((String)"types", (String)"slight_left-forward-off.png"));
        this.slight_right.setIcon(ImageProvider.get((String)"types", (String)"slight_right-forward-off.png"));
        this.left.setIcon(ImageProvider.get((String)"types", (String)"left-forward-off.png"));
        this.through.setIcon(ImageProvider.get((String)"types", (String)"through-forward-off.png"));
        this.right.setIcon(ImageProvider.get((String)"types", (String)"right-forward-off.png"));
        this.merge_to_left.setIcon(ImageProvider.get((String)"types", (String)"merge_to_left-forward-off.png"));
        this.merge_to_right.setIcon(ImageProvider.get((String)"types", (String)"merge_to_right-forward-off.png"));
        this.reverse.setIcon(ImageProvider.get((String)"types", (String)"reverse-forward-off.png"));
        this.slight_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_left-forward.png"));
        this.slight_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_right-forward.png"));
        this.left.setSelectedIcon(ImageProvider.get((String)"types", (String)"left-forward.png"));
        this.through.setSelectedIcon(ImageProvider.get((String)"types", (String)"through-forward.png"));
        this.right.setSelectedIcon(ImageProvider.get((String)"types", (String)"right-forward.png"));
        this.merge_to_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_left-forward.png"));
        this.merge_to_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_right-forward.png"));
        this.reverse.setSelectedIcon(ImageProvider.get((String)"types", (String)"reverse-forward.png"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_left, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.left, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.through, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.right, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_left, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_right, this.gbc);
    }

    public void forwareMidle() {
        this.slight_left.setIcon(ImageProvider.get((String)"types", (String)"slight_left-forward-off.png"));
        this.slight_right.setIcon(ImageProvider.get((String)"types", (String)"slight_right-forward-off.png"));
        this.left.setIcon(ImageProvider.get((String)"types", (String)"left-forward-off.png"));
        this.through.setIcon(ImageProvider.get((String)"types", (String)"through-forward-off.png"));
        this.right.setIcon(ImageProvider.get((String)"types", (String)"right-forward-off.png"));
        this.merge_to_left.setIcon(ImageProvider.get((String)"types", (String)"merge_to_left-forward-off.png"));
        this.merge_to_right.setIcon(ImageProvider.get((String)"types", (String)"merge_to_right-forward-off.png"));
        this.slight_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_left-forward.png"));
        this.slight_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_right-forward.png"));
        this.left.setSelectedIcon(ImageProvider.get((String)"types", (String)"left-forward.png"));
        this.through.setSelectedIcon(ImageProvider.get((String)"types", (String)"through-forward.png"));
        this.right.setSelectedIcon(ImageProvider.get((String)"types", (String)"right-forward.png"));
        this.merge_to_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_left-forward.png"));
        this.merge_to_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_right-forward.png"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_left, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.left, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.through, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.right, this.gbc);
    }

    public void backwardFirst() {
        this.slight_left.setIcon(ImageProvider.get((String)"types", (String)"slight_left-backward-off.png"));
        this.slight_right.setIcon(ImageProvider.get((String)"types", (String)"slight_right-backward-off.png"));
        this.left.setIcon(ImageProvider.get((String)"types", (String)"left-backward-off.png"));
        this.through.setIcon(ImageProvider.get((String)"types", (String)"through-backward-off.png"));
        this.right.setIcon(ImageProvider.get((String)"types", (String)"right-backward-off.png"));
        this.merge_to_left.setIcon(ImageProvider.get((String)"types", (String)"merge_to_left-backward-off.png"));
        this.merge_to_right.setIcon(ImageProvider.get((String)"types", (String)"merge_to_right-backward-off.png"));
        this.reverse.setIcon(ImageProvider.get((String)"types", (String)"reverse-backward-off.png"));
        this.slight_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_left-backward.png"));
        this.slight_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_right-backward.png"));
        this.left.setSelectedIcon(ImageProvider.get((String)"types", (String)"left-backward.png"));
        this.through.setSelectedIcon(ImageProvider.get((String)"types", (String)"through-backward.png"));
        this.right.setSelectedIcon(ImageProvider.get((String)"types", (String)"right-backward.png"));
        this.merge_to_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_left-backward.png"));
        this.merge_to_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_right-backward.png"));
        this.reverse.setSelectedIcon(ImageProvider.get((String)"types", (String)"reverse-backward.png"));
        this.gbc.gridx = 2;
        this.gbc.gridy = 0;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.reverse, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_left, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.left, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.through, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_left, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_right, this.gbc);
    }

    public void backwardLast() {
        this.slight_left.setIcon(ImageProvider.get((String)"types", (String)"slight_left-backward-off.png"));
        this.slight_right.setIcon(ImageProvider.get((String)"types", (String)"slight_right-backward-off.png"));
        this.left.setIcon(ImageProvider.get((String)"types", (String)"left-backward-off.png"));
        this.through.setIcon(ImageProvider.get((String)"types", (String)"through-backward-off.png"));
        this.right.setIcon(ImageProvider.get((String)"types", (String)"right-backward-off.png"));
        this.merge_to_left.setIcon(ImageProvider.get((String)"types", (String)"merge_to_left-backward-off.png"));
        this.merge_to_right.setIcon(ImageProvider.get((String)"types", (String)"merge_to_right-backward-off.png"));
        this.reverse.setIcon(ImageProvider.get((String)"types", (String)"reverse-backward-off.png"));
        this.slight_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_left-backward.png"));
        this.slight_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_right-backward.png"));
        this.left.setSelectedIcon(ImageProvider.get((String)"types", (String)"left-backward.png"));
        this.through.setSelectedIcon(ImageProvider.get((String)"types", (String)"through-backward.png"));
        this.right.setSelectedIcon(ImageProvider.get((String)"types", (String)"right-backward.png"));
        this.merge_to_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_left-backward.png"));
        this.merge_to_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_right-backward.png"));
        this.reverse.setSelectedIcon(ImageProvider.get((String)"types", (String)"reverse-backward.png"));
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_left, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.merge_to_right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.left, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.through, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_left, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_right, this.gbc);
    }

    public void backwardMidle() {
        this.slight_left.setIcon(ImageProvider.get((String)"types", (String)"slight_left-backward-off.png"));
        this.slight_right.setIcon(ImageProvider.get((String)"types", (String)"slight_right-backward-off.png"));
        this.left.setIcon(ImageProvider.get((String)"types", (String)"left-backward-off.png"));
        this.through.setIcon(ImageProvider.get((String)"types", (String)"through-backward-off.png"));
        this.right.setIcon(ImageProvider.get((String)"types", (String)"right-backward-off.png"));
        this.merge_to_left.setIcon(ImageProvider.get((String)"types", (String)"merge_to_left-backward-off.png"));
        this.merge_to_right.setIcon(ImageProvider.get((String)"types", (String)"merge_to_right-backward-off.png"));
        this.slight_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_left-backward.png"));
        this.slight_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"slight_right-backward.png"));
        this.left.setSelectedIcon(ImageProvider.get((String)"types", (String)"left-backward.png"));
        this.through.setSelectedIcon(ImageProvider.get((String)"types", (String)"through-backward.png"));
        this.right.setSelectedIcon(ImageProvider.get((String)"types", (String)"right-backward.png"));
        this.merge_to_left.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_left-backward.png"));
        this.merge_to_right.setSelectedIcon(ImageProvider.get((String)"types", (String)"merge_to_right-backward.png"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.left, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.through, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.right, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_left, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.slight_right, this.gbc);
    }

    public void both_waysOne() {
        this.left.setIcon(ImageProvider.get((String)"types", (String)"left-forward-off.png"));
        this.reversible.setIcon(ImageProvider.get((String)"types", (String)"reversible-both_ways-off.png"));
        this.right.setIcon(ImageProvider.get((String)"types", (String)"right-forward-off.png"));
        this.left.setSelectedIcon(ImageProvider.get((String)"types", (String)"left-forward.png"));
        this.reversible.setSelectedIcon(ImageProvider.get((String)"types", (String)"reversible-both_ways.png"));
        this.right.setSelectedIcon(ImageProvider.get((String)"types", (String)"right-forward.png"));
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.left, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 1;
        this.jPOptions.add((Component)this.reversible, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridy = 1;
        this.gbc.gridheight = 1;
        this.jPOptions.add((Component)this.right, this.gbc);
    }

    private class ReverseListener
    implements ActionListener {
        private ReverseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Reverse_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class Merge_to_leftListener
    implements ActionListener {
        private Merge_to_leftListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Merge_to_left_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class Merge_to_rightListener
    implements ActionListener {
        private Merge_to_rightListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Merge_to_right_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class Slight_leftListener
    implements ActionListener {
        private Slight_leftListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Slight_left_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class Slight_rightListener
    implements ActionListener {
        private Slight_rightListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Slight_right_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class ReversibleListener
    implements ActionListener {
        private ReversibleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Reversible_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class ThroughListener
    implements ActionListener {
        private ThroughListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Through_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class RightListener
    implements ActionListener {
        private RightListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Right_CHANGED, null, TurnSelection.this.bLine);
        }
    }

    private class LeftListener
    implements ActionListener {
        private LeftListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TurnSelection.this.builturn();
            TurnSelection.this.firePropertyChange(TurnSelection.Left_CHANGED, null, TurnSelection.this.bLine);
        }
    }
}

