/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;

public class DirectionTest
extends Test {
    public static final int ERROR_CODE_DIRECTION = 3731;
    public static final int ERROR_CODE_ROUNDABOUT = 3732;

    public DirectionTest() {
        super(I18n.tr((String)"Direction Test", (Object[])new Object[0]), I18n.tr((String)"Checks if the route runs against the direction of underlying one-way roads", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (RouteUtils.isTwoDirectionRoute(r)) {
            ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
            for (RelationMember rm : r.getMembers()) {
                if (!RouteUtils.isPTWay(rm) || !rm.getType().equals((Object)OsmPrimitiveType.WAY)) continue;
                waysToCheck.add(rm);
            }
            if (waysToCheck.isEmpty()) {
                return;
            }
            WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
            List links = connectionTypeCalculator.updateLinks(waysToCheck);
            for (int i = 0; i < links.size(); ++i) {
                if ((OsmUtils.isTrue((String)((RelationMember)waysToCheck.get(i)).getWay().get("oneway")) && ((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.BACKWARD) || OsmUtils.isReversed((String)((RelationMember)waysToCheck.get(i)).getWay().get("oneway")) && ((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.FORWARD)) && !((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway", "lane") && !((RelationMember)waysToCheck.get(i)).getWay().hasTag("oneway:bus", "no") && !((RelationMember)waysToCheck.get(i)).getWay().hasTag("busway", "opposite_lane") && !((RelationMember)waysToCheck.get(i)).getWay().hasTag("oneway:psv", "no") && !((RelationMember)waysToCheck.get(i)).getWay().hasTag("trolley_wire", "backward")) {
                    ArrayList<Relation> primitives = new ArrayList<Relation>(1);
                    primitives.add(r);
                    ArrayList<Way> highlighted = new ArrayList<Way>(1);
                    highlighted.add(((RelationMember)waysToCheck.get(i)).getWay());
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route passes a oneway road in wrong direction", (Object[])new Object[0]), 3731, primitives, highlighted));
                }
                if (!((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.ROUNDABOUT_LEFT) && !((WayConnectionType)links.get((int)i)).direction.equals((Object)WayConnectionType.Direction.ROUNDABOUT_RIGHT)) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route passes on an unsplit roundabout", (Object[])new Object[0]), 3732, (OsmPrimitive)((RelationMember)waysToCheck.get(i)).getWay()));
            }
        }
    }

    public Command fixError(TestError testError) {
        ArrayList<ChangeCommand> commands = new ArrayList<ChangeCommand>(50);
        if (testError.getTester().getClass().equals(DirectionTest.class) && testError.isFixable()) {
            List primitives = (List)testError.getPrimitives();
            Relation originalRelation = (Relation)primitives.get(0);
            List highlightedList = (List)testError.getHighlighted();
            Way wayToRemove = (Way)highlightedList.get(0);
            Relation modifiedRelation = new Relation(originalRelation);
            ArrayList<RelationMember> modifiedRelationMembers = new ArrayList<RelationMember>(originalRelation.getMembersCount() - 1);
            for (RelationMember rm : originalRelation.getMembers()) {
                if (!RouteUtils.isPTStop(rm)) continue;
                if (rm.getRole().equals("stop_position")) {
                    RelationMember newMember;
                    if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
                        newMember = new RelationMember("stop", (OsmPrimitive)rm.getNode());
                        modifiedRelationMembers.add(newMember);
                        continue;
                    }
                    newMember = new RelationMember("stop", (OsmPrimitive)rm.getWay());
                    modifiedRelationMembers.add(newMember);
                    continue;
                }
                modifiedRelationMembers.add(rm);
            }
            for (RelationMember rm : originalRelation.getMembers()) {
                Way wayToCheck;
                if (!RouteUtils.isPTWay(rm) || (wayToCheck = rm.getWay()) == wayToRemove) continue;
                if (rm.getRole().equals("forward") || rm.getRole().equals("backward")) {
                    RelationMember modifiedMember = new RelationMember("", (OsmPrimitive)wayToCheck);
                    modifiedRelationMembers.add(modifiedMember);
                    continue;
                }
                modifiedRelationMembers.add(rm);
            }
            modifiedRelation.setMembers(modifiedRelationMembers);
            ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
            commands.add(changeCommand);
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Remove way from route if it does not match the route type", (Object[])new Object[0]), commands);
    }

    public boolean isFixable(TestError testError) {
        return testError.getCode() == 3731;
    }
}

