/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class RouteUtils {
    private RouteUtils() {
    }

    public static boolean isTwoDirectionRoute(Relation r) {
        if (!r.hasKey("route") || !r.hasTag("public_transport:version", "2")) {
            return false;
        }
        return r.hasTag("route", "bus") || r.hasTag("route", "trolleybus") || r.hasTag("route", "share_taxi") || r.hasTag("route", "tram") || r.hasTag("route", "light_rail") || r.hasTag("route", "subway") || r.hasTag("route", "train");
    }

    public static boolean isPTStop(RelationMember rm) {
        if (rm.getType().equals((Object)OsmPrimitiveType.NODE)) {
            return true;
        }
        if (rm.getType().equals((Object)OsmPrimitiveType.RELATION)) {
            return rm.getRole().equals("stop_area");
        }
        Way w = rm.getWay();
        return w.hasTag("public_transport", "platform") || w.hasTag("highway", "platform") || w.hasTag("railway", "platform") || w.hasTag("public_transport", "platform_entry_only") || w.hasTag("highway", "platform_entry_only") || w.hasTag("railway", "platform_entry_only") || w.hasTag("public_transport", "platform_exit_only") || w.hasTag("highway", "platform_exit_only") || w.hasTag("railway", "platform_exit_only");
    }

    public static boolean isPTWay(RelationMember rm) {
        return !RouteUtils.isPTStop(rm);
    }

    public static boolean isWaySuitableForBuses(Way way) {
        return way.hasTag("highway", "motorway") || way.hasTag("highway", "trunk") || way.hasTag("highway", "primary") || way.hasTag("highway", "secondary") || way.hasTag("highway", "tertiary") || way.hasTag("highway", "unclassified") || way.hasTag("highway", "road") || way.hasTag("highway", "residential") || way.hasTag("highway", "service") || way.hasTag("highway", "motorway_link") || way.hasTag("highway", "trunk_link") || way.hasTag("highway", "primary_link") || way.hasTag("highway", "secondary_link") || way.hasTag("highway", "tertiary_link") || way.hasTag("highway", "living_street") || way.hasTag("highway", "bus_guideway") || way.hasTag("highway", "road") || way.hasTag("cycleway", "share_busway") || way.hasTag("cycleway", "shared_lane");
    }
}

