/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.plugins.pt_assistant.validation.GapTest;
import org.openstreetmap.josm.tools.I18n;

public class RoadTypeTest
extends Test {
    public static final int ERROR_CODE_ROAD_TYPE = 3721;

    public RoadTypeTest() {
        super(I18n.tr((String)"Road Type Test", (Object[])new Object[0]), I18n.tr((String)"Checks if the course of the route relation is compatible with the type of the road it passes on.", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (RouteUtils.isTwoDirectionRoute(r)) {
            List members = r.getMembers();
            for (RelationMember rm : members) {
                if (!RouteUtils.isPTWay(rm)) continue;
                Way way = rm.getWay();
                boolean isCorrectRoadType = true;
                if (r.hasTag("route", "bus") || r.hasTag("route", "share_taxi")) {
                    if (!RouteUtils.isWaySuitableForBuses(way)) {
                        isCorrectRoadType = false;
                    }
                } else if (r.hasTag("route", "trolleybus")) {
                    if (!RouteUtils.isWaySuitableForBuses(way) || !way.hasTag("trolley_wire", "yes")) {
                        isCorrectRoadType = false;
                    }
                } else if (r.hasTag("route", "tram")) {
                    if (!r.hasTag("railway", "tram")) {
                        isCorrectRoadType = false;
                    }
                } else if (r.hasTag("route", "subway")) {
                    if (!r.hasTag("railway", "subway")) {
                        isCorrectRoadType = false;
                    }
                } else if (r.hasTag("route", "light_rail")) {
                    if (!r.hasTag("raiilway", "subway")) {
                        isCorrectRoadType = false;
                    }
                } else if (r.hasTag("route", "light_rail")) {
                    if (!r.hasTag("railway", "light_rail")) {
                        isCorrectRoadType = false;
                    }
                } else if (r.hasTag("route", "train") && !r.hasTag("railway", "train")) {
                    isCorrectRoadType = false;
                }
                if (isCorrectRoadType) continue;
                ArrayList<Object> primitiveList = new ArrayList<Object>(2);
                primitiveList.add(0, r);
                primitiveList.add(1, way);
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route type does not match the type of the road it passes on", (Object[])new Object[0]), 3721, primitiveList));
            }
        }
    }

    public Command fixError(TestError testError) {
        ArrayList<ChangeCommand> commands = new ArrayList<ChangeCommand>(50);
        if (testError.getTester().getClass().equals(GapTest.class) && testError.isFixable()) {
            List primitiveList = (List)testError.getPrimitives();
            Relation originalRelation = (Relation)primitiveList.get(0);
            Way wayToRemove = (Way)primitiveList.get(1);
            Relation modifiedRelation = new Relation(originalRelation);
            ArrayList<RelationMember> modifiedRelationMembers = new ArrayList<RelationMember>(originalRelation.getMembersCount() - 1);
            for (RelationMember rm : originalRelation.getMembers()) {
                if (!RouteUtils.isPTStop(rm)) continue;
                modifiedRelationMembers.add(rm);
            }
            for (RelationMember rm : originalRelation.getMembers()) {
                Way wayToCheck;
                if (!RouteUtils.isPTWay(rm) || (wayToCheck = rm.getWay()) == wayToRemove) continue;
                modifiedRelationMembers.add(rm);
            }
            modifiedRelation.setMembers(modifiedRelationMembers);
            ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
            commands.add(changeCommand);
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Remove way from route if it does not match the route type", (Object[])new Object[0]), commands);
    }

    public boolean isFixable(TestError testError) {
        return testError.getCode() == 3721;
    }
}

