/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.plugins.pt_assistant.utils.RouteUtils;
import org.openstreetmap.josm.tools.I18n;

public class GapTest
extends Test {
    public static final int ERROR_CODE_SORTING = 3711;
    public static final int ERROR_CODE_OVERSHOOT = 3712;
    public static final int ERROR_CODE_OTHER_GAP = 3719;
    private List<RelationMember> overshootList = new ArrayList<RelationMember>();

    public GapTest() {
        super(I18n.tr((String)"Gaps", (Object[])new Object[0]), I18n.tr((String)"Checks if there are gaps in the route relation.", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (RouteUtils.isTwoDirectionRoute(r)) {
            List members = r.getMembers();
            ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
            for (RelationMember member : members) {
                if (!RouteUtils.isPTWay(member)) continue;
                waysToCheck.add(member);
            }
            if (waysToCheck.isEmpty()) {
                return;
            }
            if (this.hasGap(waysToCheck)) {
                RelationSorter sorter = new RelationSorter();
                List correctedList = sorter.sortMembers(waysToCheck);
                if (!this.hasGap(correctedList)) {
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route contains a gap that can be fixed by sorting", (Object[])new Object[0]), 3711, (OsmPrimitive)r));
                } else {
                    List<RelationMember> overshoots = this.getOvershoots(correctedList);
                    if (!overshoots.isEmpty()) {
                        this.overshootList = overshoots;
                        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route contains an overshoot", (Object[])new Object[0]), 3712, (OsmPrimitive)r));
                    } else {
                        this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route contains a gap that cannot be fixed by sorting the ways", (Object[])new Object[0]), 3719, (OsmPrimitive)r));
                    }
                }
            }
        }
    }

    private boolean hasGap(List<RelationMember> waysToCheck) {
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(waysToCheck);
        for (int i = 0; i < links.size(); ++i) {
            boolean hasError;
            WayConnectionType link = (WayConnectionType)links.get(i);
            boolean bl = hasError = i != 0 && !link.linkPrev || i != links.size() - 1 && !link.linkNext || link.direction == null || WayConnectionType.Direction.NONE.equals((Object)link.direction);
            if (!hasError) continue;
            return true;
        }
        return false;
    }

    private List<RelationMember> getOvershoots(List<RelationMember> sortedWays) {
        ArrayList<RelationMember> overshoots = new ArrayList<RelationMember>();
        if (sortedWays.size() < 5) {
            return overshoots;
        }
        for (int i = 2; i < sortedWays.size() - 3; ++i) {
            boolean lastNodeConnectedToNext;
            Way prev = sortedWays.get(i - 1).getWay();
            Way curr = sortedWays.get(i).getWay();
            Way next = sortedWays.get(i + 1).getWay();
            boolean firstNodeConnectedToPrev = curr.firstNode() == prev.firstNode() || curr.firstNode() == prev.lastNode();
            boolean lastNodeConnectedToPrev = curr.lastNode() == prev.firstNode() || curr.lastNode() == prev.lastNode();
            boolean firstNodeConnectedToNext = curr.firstNode() == next.firstNode() || curr.firstNode() == next.lastNode();
            boolean bl = lastNodeConnectedToNext = curr.lastNode() == next.firstNode() || curr.lastNode() == next.lastNode();
            if ((!firstNodeConnectedToPrev || !firstNodeConnectedToNext) && (!lastNodeConnectedToPrev || !lastNodeConnectedToNext)) continue;
            overshoots.add(sortedWays.get(i));
        }
        return overshoots;
    }

    public Command fixError(TestError testError) {
        ArrayList<ChangeCommand> commands = new ArrayList<ChangeCommand>(50);
        if (testError.getTester().getClass().equals(GapTest.class) && testError.isFixable()) {
            if (testError.getCode() == 3711) {
                for (OsmPrimitive primitive : testError.getPrimitives()) {
                    Relation relation = (Relation)primitive;
                    List members = relation.getMembers();
                    ArrayList<RelationMember> stops = new ArrayList<RelationMember>();
                    ArrayList<RelationMember> ways = new ArrayList<RelationMember>();
                    for (RelationMember member : members) {
                        if (member.hasRole(new String[]{""}) && OsmPrimitiveType.WAY.equals((Object)member.getType())) {
                            ways.add(member);
                            continue;
                        }
                        stops.add(member);
                    }
                    RelationSorter sorter = new RelationSorter();
                    List sortedWays = sorter.sortMembers(ways);
                    Relation sortedRelation = new Relation(relation);
                    ArrayList<RelationMember> sortedRelationMembers = new ArrayList<RelationMember>(members.size());
                    for (RelationMember rm : stops) {
                        sortedRelationMembers.add(rm);
                    }
                    for (RelationMember rm : sortedWays) {
                        sortedRelationMembers.add(rm);
                    }
                    sortedRelation.setMembers(sortedRelationMembers);
                    ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)relation, (OsmPrimitive)sortedRelation);
                    commands.add(changeCommand);
                }
            }
            if (testError.getCode() == 3712) {
                for (OsmPrimitive primitive : testError.getPrimitives()) {
                    Relation originalRelation = (Relation)primitive;
                    Relation modifiedRelation = new Relation(originalRelation);
                    ArrayList<RelationMember> modifiedMembers = new ArrayList<RelationMember>();
                    for (RelationMember rm : originalRelation.getMembers()) {
                        if (!RouteUtils.isPTStop(rm)) continue;
                        modifiedMembers.add(rm);
                    }
                    for (RelationMember rm : originalRelation.getMembers()) {
                        if (!RouteUtils.isPTWay(rm) || this.overshootList.contains(rm)) continue;
                        modifiedMembers.add(rm);
                    }
                    modifiedRelation.setMembers(modifiedMembers);
                    ChangeCommand changeCommand = new ChangeCommand((OsmPrimitive)originalRelation, (OsmPrimitive)modifiedRelation);
                    commands.add(changeCommand);
                }
            }
        }
        if (commands.isEmpty()) {
            return null;
        }
        if (commands.size() == 1) {
            return (Command)commands.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Fix gaps in public transport route", (Object[])new Object[0]), commands);
    }

    public boolean isFixable(TestError testError) {
        return testError.getCode() == 3711 || testError.getCode() == 3712;
    }
}

