/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.utils;

import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class RouteUtils {
    private RouteUtils() {
    }

    public static boolean isTwoDirectionRoute(Relation r) {
        if (!r.hasKey("route") || !r.hasTag("public_transport:version", "2")) {
            return false;
        }
        return r.hasTag("route", "bus") || r.hasTag("route", "trolleybus") || r.hasTag("route", "share_taxi") || r.hasTag("route", "tram") || r.hasTag("route", "light_rail") || r.hasTag("route", "subway") || r.hasTag("route", "train");
    }

    public static boolean isPTStop(RelationMember rm) {
        return !RouteUtils.isPTWay(rm);
    }

    public static boolean isPTWay(RelationMember rm) {
        Way way;
        return rm.hasRole(new String[]{""}) && OsmPrimitiveType.WAY.equals((Object)rm.getType()) && !(way = rm.getWay()).hasTag("public_transport", "platform") && !way.hasTag("highway", "platform") && !way.hasTag("railway", "platform");
    }
}

