/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validation;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionTypeCalculator;
import org.openstreetmap.josm.tools.I18n;

public class GapTest
extends Test {
    public static final int ERROR_CODE_SORTING = 3711;
    public static final int ERROR_CODE_OTHER_GAP = 3712;

    public GapTest() {
        super(I18n.tr((String)"Gaps", (Object[])new Object[0]), I18n.tr((String)"Checks if there are gaps in the route relation.", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (r.hasKey("route")) {
            List members = r.getMembers();
            ArrayList<RelationMember> waysToCheck = new ArrayList<RelationMember>();
            for (RelationMember member : members) {
                if (!member.hasRole(new String[]{""}) || !OsmPrimitiveType.WAY.equals((Object)member.getType())) continue;
                waysToCheck.add(member);
            }
            if (waysToCheck.isEmpty()) {
                return;
            }
            if (this.hasGap(waysToCheck)) {
                RelationSorter sorter = new RelationSorter();
                List correctedList = sorter.sortMembers(waysToCheck);
                if (this.hasGap(correctedList)) {
                    System.out.println("other error type");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route contains a gap that cannot be fixed by sorting the ways.", (Object[])new Object[0]), 3712, (OsmPrimitive)r));
                } else {
                    System.out.println("sorting error");
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: Route contains a gap that can be fixed by sorting", (Object[])new Object[0]), 3711, (OsmPrimitive)r));
                }
            }
        }
    }

    private boolean hasGap(List<RelationMember> waysToCheck) {
        WayConnectionTypeCalculator connectionTypeCalculator = new WayConnectionTypeCalculator();
        List links = connectionTypeCalculator.updateLinks(waysToCheck);
        for (int i = 0; i < links.size(); ++i) {
            boolean hasError;
            WayConnectionType link = (WayConnectionType)links.get(i);
            boolean bl = hasError = i != 0 && !link.linkPrev || i != links.size() - 1 && !link.linkNext || link.direction == null || WayConnectionType.Direction.NONE.equals((Object)link.direction);
            if (!hasError) continue;
            return true;
        }
        return false;
    }
}

