/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pt_assistant.validator;

import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class PlatformsFirst
extends Test {
    public PlatformsFirst() {
        super(I18n.tr((String)"Platforms first", (Object[])new Object[0]), I18n.tr((String)"Checks if platforms are listed before ways in the route relation.", (Object[])new Object[0]));
    }

    public void visit(Relation r) {
        if (r.hasKey("route")) {
            List members = r.getMembers();
            RelationMember prevMember = null;
            for (RelationMember currMember : members) {
                if (prevMember != null && currMember.hasRole(new String[]{"platform"}) && prevMember.getType().equals((Object)OsmPrimitiveType.WAY)) {
                    this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr((String)"PT: route relation(s) contain(s) way(s) before platform(s) in the members list", (Object[])new Object[0]), 9999, (OsmPrimitive)r));
                    return;
                }
                prevMember = currMember;
            }
        }
    }
}

