/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.IndexColorModel;

public abstract class ImageModifier {
    protected int parcelColor = Color.RED.getRGB();
    public BufferedImage bufferedImage;
    public static int[] cRoofColors = new int[]{-197380, -592138};
    public static int[] cBuilingFootColors = new int[]{-256};

    protected BufferedImage convert1(BufferedImage src) {
        IndexColorModel icm = new IndexColorModel(1, 2, new byte[]{0, -1}, new byte[]{0, -1}, new byte[]{0, -1});
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 12, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    protected BufferedImage convert4(BufferedImage src) {
        int[] cmap = new int[]{0, 0x800000, 32768, 0x808000, 128, 0x800080, 32896, 0x808080, 0xC0C0C0, 0xFF0000, 65280, 0xFFFF00, 255, 0xFF00FF, 65535, 0xFFFFFF};
        return this.convert4(src, cmap);
    }

    protected BufferedImage convert4(BufferedImage src, int[] cmap) {
        IndexColorModel icm = new IndexColorModel(4, cmap.length, cmap, 0, false, 1, 0);
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 12, icm);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    protected BufferedImage convert8(BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 13);
        ColorConvertOp cco = new ColorConvertOp(src.getColorModel().getColorSpace(), dest.getColorModel().getColorSpace(), null);
        cco.filter(src, dest);
        return dest;
    }

    public boolean isBuildingColor(int rgb, boolean ignoreParcelColor) {
        for (int i = 0; i < cBuilingFootColors.length; ++i) {
            if (rgb != cBuilingFootColors[i]) continue;
            return true;
        }
        return ignoreParcelColor && rgb == this.parcelColor;
    }

    public boolean isRoofColor(int rgb, boolean ignoreParcelColor) {
        for (int i = 0; i < cRoofColors.length; ++i) {
            if (rgb != cRoofColors[i]) continue;
            return true;
        }
        return ignoreParcelColor && rgb == this.parcelColor;
    }

    public boolean isParcelColor(BufferedImage img, int x, int y) {
        int rgb = img.getRGB(x, y);
        return rgb == this.parcelColor;
    }

    public boolean isBuildingOrRoofColor(BufferedImage img, int x, int y, boolean ignoreParcelColor) {
        int rgb = img.getRGB(x, y);
        boolean ret = this.isBuildingColor(rgb, ignoreParcelColor) || this.isRoofColor(rgb, ignoreParcelColor);
        return ret;
    }

    public boolean isBuildingOrRoofColor(BufferedImage img, int x, int y, boolean colorType, boolean ignoreParcelColor) {
        int rgb = img.getRGB(x, y);
        boolean ret = colorType ? this.isBuildingColor(rgb, ignoreParcelColor) : this.isRoofColor(rgb, ignoreParcelColor);
        return ret;
    }

    public boolean isBackgroundColor(BufferedImage img, int x, int y) {
        return img.getRGB(x, y) == -1;
    }
}

