/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Set;

public class RedundantImportCheck
extends AbstractCheck {
    public static final String MSG_LANG = "import.lang";
    public static final String MSG_SAME = "import.same";
    public static final String MSG_DUPLICATE = "import.duplicate";
    private final Set<FullIdent> imports = Sets.newHashSet();
    private final Set<FullIdent> staticImports = Sets.newHashSet();
    private String pkgName;

    @Override
    public void beginTree(DetailAST aRootAST) {
        this.pkgName = null;
        this.imports.clear();
        this.staticImports.clear();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152, 16};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 16) {
            this.pkgName = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling()).getText();
        } else if (ast.getType() == 30) {
            FullIdent imp = FullIdent.createFullIdentBelow(ast);
            if (RedundantImportCheck.isFromPackage(imp.getText(), "java.lang")) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_LANG, imp.getText());
            } else if (this.pkgName != null && RedundantImportCheck.isFromPackage(imp.getText(), this.pkgName)) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_SAME, imp.getText());
            }
            for (FullIdent full : this.imports) {
                if (!imp.getText().equals(full.getText())) continue;
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_DUPLICATE, full.getLineNo(), imp.getText());
            }
            this.imports.add(imp);
        } else {
            FullIdent imp = FullIdent.createFullIdent(ast.getLastChild().getPreviousSibling());
            for (FullIdent full : this.staticImports) {
                if (!imp.getText().equals(full.getText())) continue;
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_DUPLICATE, full.getLineNo(), imp.getText());
            }
            this.staticImports.add(imp);
        }
    }

    private static boolean isFromPackage(String importName, String pkg) {
        int index = importName.lastIndexOf(46);
        String front = importName.substring(0, index);
        return front.equals(pkg);
    }
}

