/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.hot.sds.SdsCredentialDialog;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.io.CredentialDialog;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.auth.AbstractCredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsAgentResponse;
import org.openstreetmap.josm.tools.I18n;

public class SdsCredentialAgent
extends AbstractCredentialsAgent {
    Map<Authenticator.RequestorType, PasswordAuthentication> sdsMemoryCredentialsCache = new HashMap<Authenticator.RequestorType, PasswordAuthentication>();

    public PasswordAuthentication lookup(Authenticator.RequestorType requestorType, String host) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        switch (requestorType) {
            case SERVER: {
                String user = Main.pref.get("sds-server.username", null);
                String password = Main.pref.get("sds-server.password", null);
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }
            case PROXY: {
                String user = Main.pref.get("proxy.user", null);
                String password = Main.pref.get("proxy.pass", null);
                if (user == null) {
                    return null;
                }
                return new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
            }
        }
        return null;
    }

    public void store(Authenticator.RequestorType requestorType, String host, PasswordAuthentication credentials) throws CredentialsAgentException {
        if (requestorType == null) {
            return;
        }
        switch (requestorType) {
            case SERVER: {
                Main.pref.put("sds-server.username", credentials.getUserName());
                if (credentials.getPassword() == null) {
                    Main.pref.put("sds-server.password", null);
                    break;
                }
                Main.pref.put("sds-server.password", String.valueOf(credentials.getPassword()));
                break;
            }
            case PROXY: {
                Main.pref.put("proxy.user", credentials.getUserName());
                if (credentials.getPassword() == null) {
                    Main.pref.put("proxy.pass", null);
                    break;
                }
                Main.pref.put("proxy.pass", String.valueOf(credentials.getPassword()));
            }
        }
    }

    public OAuthToken lookupOAuthAccessToken() throws CredentialsAgentException {
        String accessTokenKey = Main.pref.get("oauth.access-token.key", null);
        String accessTokenSecret = Main.pref.get("oauth.access-token.secret", null);
        if (accessTokenKey == null && accessTokenSecret == null) {
            return null;
        }
        return new OAuthToken(accessTokenKey, accessTokenSecret);
    }

    public Component getPreferencesDecorationPanel() {
        HtmlPanel pnlMessage = new HtmlPanel();
        HTMLEditorKit kit = (HTMLEditorKit)pnlMessage.getEditorPane().getEditorKit();
        kit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
        pnlMessage.setText(I18n.tr((String)"<html><body><p class=\"warning-body\"><strong>Warning:</strong> The password is stored in plain text in the JOSM preferences file. </p></body></html>", (Object[])new Object[0]));
        return pnlMessage;
    }

    public String getSaveUsernameAndPasswordCheckboxText() {
        return I18n.tr((String)"Save user and password (unencrypted)", (Object[])new Object[0]);
    }

    public void storeOAuthAccessToken(OAuthToken accessToken) throws CredentialsAgentException {
    }

    public CredentialsAgentResponse getCredentials(Authenticator.RequestorType requestorType, String host, boolean noSuccessWithLastResponse) throws CredentialsAgentException {
        if (requestorType == null) {
            return null;
        }
        PasswordAuthentication credentials = this.lookup(requestorType, host);
        String username = credentials == null || credentials.getUserName() == null ? "" : credentials.getUserName();
        String password = credentials == null || credentials.getPassword() == null ? "" : String.valueOf(credentials.getPassword());
        CredentialsAgentResponse response = new CredentialsAgentResponse();
        if (!noSuccessWithLastResponse && this.sdsMemoryCredentialsCache.containsKey((Object)requestorType) && (credentials == null || credentials.getPassword() == null || credentials.getPassword().length == 0)) {
            PasswordAuthentication pa = this.sdsMemoryCredentialsCache.get((Object)requestorType);
            response.setUsername(pa.getUserName());
            response.setPassword(pa.getPassword());
            response.setCanceled(false);
        } else if (noSuccessWithLastResponse || username.equals("") || password.equals("")) {
            SdsCredentialDialog dialog = null;
            switch (requestorType) {
                case SERVER: {
                    dialog = SdsCredentialDialog.getSdsApiCredentialDialog(username, password, host, this.getSaveUsernameAndPasswordCheckboxText());
                    break;
                }
                case PROXY: {
                    dialog = CredentialDialog.getHttpProxyCredentialDialog((String)username, (String)password, (String)host, (String)this.getSaveUsernameAndPasswordCheckboxText());
                }
            }
            dialog.setVisible(true);
            response.setCanceled(dialog.isCanceled());
            if (dialog.isCanceled()) {
                return response;
            }
            response.setUsername(dialog.getUsername());
            response.setPassword(dialog.getPassword());
            if (dialog.isSaveCredentials()) {
                this.store(requestorType, host, new PasswordAuthentication(response.getUsername(), response.getPassword()));
            } else {
                PasswordAuthentication pa = new PasswordAuthentication(dialog.getUsername(), dialog.getPassword());
                this.sdsMemoryCredentialsCache.put(requestorType, pa);
            }
        } else {
            response.setUsername(username);
            response.setPassword(password.toCharArray());
            response.setCanceled(false);
        }
        return response;
    }
}

