/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.AddrInterpolation;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.AddrInterpolation.EscapeDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddrInterpolationDialog
extends JDialog
implements ActionListener {
    private Way selectedStreet = null;
    private Way addrInterpolationWay = null;
    private Relation associatedStreetRelation = null;
    private ArrayList<Node> houseNumberNodes = null;
    private static String lastIncrement = "";
    private static int lastAccuracyIndex = 0;
    private static String lastCity = "";
    private static String lastState = "";
    private static String lastPostCode = "";
    private static String lastCountry = "";
    private static String lastFullAddress = "";
    private static boolean lastConvertToHousenumber = false;
    private EscapeDialog dialog = null;
    private JRadioButton streetNameButton = null;
    private JRadioButton streetRelationButton = null;
    private JTextField startTextField = null;
    private JTextField endTextField = null;
    private JTextField incrementTextField = null;
    private JTextField cityTextField = null;
    private JTextField stateTextField = null;
    private JTextField postCodeTextField = null;
    private JTextField countryTextField = null;
    private JTextField fullTextField = null;
    private Checkbox cbConvertToHouseNumbers = null;
    private boolean relationChanged = false;
    private boolean interpolationMethodSet = false;
    String[] addrInterpolationTags = new String[]{"odd", "even", "all", "alphabetic", "Numeric"};
    String[] addrInterpolationStrings = new String[]{I18n.tr((String)"Odd", (Object[])new Object[0]), I18n.tr((String)"Even", (Object[])new Object[0]), I18n.tr((String)"All", (Object[])new Object[0]), I18n.tr((String)"Alphabetic", (Object[])new Object[0]), I18n.tr((String)"Numeric", (Object[])new Object[0])};
    private final int NumericIndex = 4;
    private JComboBox<String> addrInterpolationList = null;
    String[] addrInclusionTags = new String[]{"actual", "estimate", "potential"};
    String[] addrInclusionStrings = new String[]{I18n.tr((String)"Actual", (Object[])new Object[0]), I18n.tr((String)"Estimate", (Object[])new Object[0]), I18n.tr((String)"Potential", (Object[])new Object[0])};
    private JComboBox<String> addrInclusionList = null;
    private Collection<Command> commandGroup = null;
    private Relation editedRelation = null;
    private static Pattern p = Pattern.compile("^[0-9]+$");

    public AddrInterpolationDialog(String name) {
        if (!this.FindAndSaveSelections()) {
            return;
        }
        JPanel editControlsPane = this.CreateEditControls();
        this.ShowDialog(editControlsPane, name);
    }

    private void ShowDialog(JPanel editControlsPane, String name) {
        this.dialog = new EscapeDialog((Frame)Main.parent, name, true);
        this.dialog.add(editControlsPane);
        this.dialog.setSize(new Dimension(300, 500));
        this.dialog.setLocation(new Point(100, 300));
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (AddrInterpolationDialog.this.addrInterpolationWay != null) {
                    AddrInterpolationDialog.this.startTextField.requestFocus();
                } else {
                    AddrInterpolationDialog.this.cityTextField.requestFocus();
                }
            }
        });
        this.dialog.setVisible(true);
        lastIncrement = this.incrementTextField.getText();
        lastCity = this.cityTextField.getText();
        lastState = this.stateTextField.getText();
        lastPostCode = this.postCodeTextField.getText();
        lastCountry = this.countryTextField.getText();
        lastFullAddress = this.fullTextField.getText();
        lastConvertToHousenumber = this.cbConvertToHouseNumbers.getState();
    }

    private JPanel CreateEditControls() {
        JPanel editControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        editControlsPane.setLayout(gridbag);
        editControlsPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        String streetName = this.selectedStreet.get("name");
        String streetRelation = this.FindRelation();
        if (streetRelation.equals("")) {
            streetRelation = " (Create new)";
        }
        this.streetNameButton = new JRadioButton(I18n.tr((String)"Name: {0}", (Object[])new Object[]{streetName}));
        this.streetRelationButton = new JRadioButton(I18n.tr((String)"Relation: {0}", (Object[])new Object[]{streetRelation}));
        if (this.associatedStreetRelation == null) {
            this.streetNameButton.setSelected(true);
        } else {
            this.streetRelationButton.setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.streetNameButton);
        group.add(this.streetRelationButton);
        JPanel radioButtonPanel = new JPanel(new BorderLayout());
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Associate with street using:", (Object[])new Object[0])));
        radioButtonPanel.add((Component)this.streetNameButton, "North");
        radioButtonPanel.add((Component)this.streetRelationButton, "South");
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.gridwidth = 0;
        editControlsPane.add((Component)radioButtonPanel, c);
        JLabel numberingLabel = new JLabel(I18n.tr((String)"Numbering Scheme:", (Object[])new Object[0]));
        this.addrInterpolationList = new JComboBox<String>(this.addrInterpolationStrings);
        JLabel incrementLabel = new JLabel(I18n.tr((String)"Increment:", (Object[])new Object[0]));
        this.incrementTextField = new JTextField(lastIncrement, 100);
        this.incrementTextField.setEnabled(false);
        JLabel startLabel = new JLabel(I18n.tr((String)"Starting #:", (Object[])new Object[0]));
        JLabel endLabel = new JLabel(I18n.tr((String)"Ending #:", (Object[])new Object[0]));
        this.startTextField = new JTextField(10);
        this.endTextField = new JTextField(10);
        JLabel inclusionLabel = new JLabel(I18n.tr((String)"Accuracy:", (Object[])new Object[0]));
        this.addrInclusionList = new JComboBox<String>(this.addrInclusionStrings);
        this.addrInclusionList.setSelectedIndex(lastAccuracyIndex);
        this.GetExistingMapKeys();
        JLabel[] textLabels = new JLabel[]{startLabel, endLabel, numberingLabel, incrementLabel, inclusionLabel};
        Component[] editFields = new Component[]{this.startTextField, this.endTextField, this.addrInterpolationList, this.incrementTextField, this.addrInclusionList};
        this.AddEditControlRows(textLabels, editFields, editControlsPane);
        this.cbConvertToHouseNumbers = new Checkbox(I18n.tr((String)"Convert way to individual house numbers.", (Object[])new Object[0]), null, lastConvertToHousenumber);
        if (this.addrInterpolationWay == null) {
            this.addrInterpolationList.setEnabled(false);
            this.startTextField.setEnabled(false);
            this.endTextField.setEnabled(false);
            this.cbConvertToHouseNumbers.setEnabled(false);
        }
        JPanel optionPanel = this.CreateOptionalFields();
        c.gridx = 0;
        c.gridwidth = 2;
        c.fill = 1;
        c.gridwidth = 0;
        editControlsPane.add((Component)optionPanel, c);
        KeyAdapter enterProcessor = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && AddrInterpolationDialog.this.ValidateAndSave()) {
                    AddrInterpolationDialog.this.dialog.dispose();
                }
            }
        };
        this.endTextField.addKeyListener(enterProcessor);
        this.cityTextField.addKeyListener(enterProcessor);
        this.addrInterpolationList.addKeyListener(enterProcessor);
        this.incrementTextField.addKeyListener(enterProcessor);
        this.addrInterpolationList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                if (!AddrInterpolationDialog.this.interpolationMethodSet && AddrInterpolationDialog.this.AutoDetectInterpolationMethod()) {
                    AddrInterpolationDialog.this.interpolationMethodSet = true;
                }
            }
        });
        this.addrInterpolationList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = AddrInterpolationDialog.this.addrInterpolationList.getSelectedIndex();
                AddrInterpolationDialog.this.incrementTextField.setEnabled(selectedIndex == 4);
            }
        });
        editControlsPane.add((Component)this.cbConvertToHouseNumbers, c);
        if (this.houseNumberNodes.size() > 0) {
            JLabel houseNumberNodeNote = new JLabel(I18n.tr((String)"Will associate {0} additional house number nodes", (Object[])new Object[]{this.houseNumberNodes.size()}));
            editControlsPane.add((Component)houseNumberNodeNote, c);
        }
        editControlsPane.add((Component)new UrlLabel("http://wiki.openstreetmap.org/wiki/JOSM/Plugins/AddrInterpolation", I18n.tr((String)"More information about this feature", (Object[])new Object[0]), 2), c);
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(15, 0, 0, 0);
        c.anchor = 22;
        JButton okButton = new JButton(I18n.tr((String)"OK", (Object[])new Object[0]), ImageProvider.get((String)"ok"));
        editControlsPane.add((Component)okButton, c);
        c.gridx = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.anchor = 21;
        JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]), ImageProvider.get((String)"cancel"));
        editControlsPane.add((Component)cancelButton, c);
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        return editControlsPane;
    }

    private boolean AutoDetectInterpolationMethod() {
        String startValueString = this.ReadTextField(this.startTextField);
        String endValueString = this.ReadTextField(this.endTextField);
        if (startValueString == null || endValueString == null) {
            return false;
        }
        if (this.isLong(startValueString) && this.isLong(endValueString)) {
            long startValue = Long.parseLong(startValueString);
            long endValue = Long.parseLong(endValueString);
            if (this.isEven(startValue)) {
                if (this.isEven(endValue)) {
                    this.SelectInterpolationMethod("even");
                } else {
                    this.SelectInterpolationMethod("all");
                }
            } else if (!this.isEven(endValue)) {
                this.SelectInterpolationMethod("odd");
            } else {
                this.SelectInterpolationMethod("all");
            }
        } else {
            char startingChar = startValueString.charAt(startValueString.length() - 1);
            char endingChar = endValueString.charAt(endValueString.length() - 1);
            if (!AddrInterpolationDialog.IsNumeric("" + startingChar) && !AddrInterpolationDialog.IsNumeric("" + endingChar)) {
                this.SelectInterpolationMethod("alphabetic");
                return true;
            }
            if (AddrInterpolationDialog.IsNumeric("" + startingChar) && !AddrInterpolationDialog.IsNumeric("" + endingChar) && (endingChar = Character.toUpperCase(endingChar)) >= 'A' && endingChar <= 'Z') {
                this.SelectInterpolationMethod("alphabetic");
                return true;
            }
            return false;
        }
        return true;
    }

    private void SelectInterpolationMethod(String currentMethod) {
        int currentIndex = 0;
        if (this.isLong(currentMethod)) {
            currentIndex = this.addrInterpolationTags.length - 1;
            this.incrementTextField.setText(currentMethod);
            this.incrementTextField.setEnabled(true);
        } else {
            for (int i = 0; i < this.addrInterpolationTags.length; ++i) {
                if (!this.addrInterpolationTags[i].equals(currentMethod)) continue;
                currentIndex = i;
                break;
            }
        }
        this.addrInterpolationList.setSelectedIndex(currentIndex);
    }

    private void SelectInclusion(String currentMethod) {
        int currentIndex = 0;
        for (int i = 0; i < this.addrInclusionTags.length; ++i) {
            if (!this.addrInclusionTags[i].equals(currentMethod)) continue;
            currentIndex = i;
            break;
        }
        this.addrInclusionList.setSelectedIndex(currentIndex);
    }

    private JPanel CreateOptionalFields() {
        JPanel editControlsPane = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        editControlsPane.setLayout(gridbag);
        editControlsPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel[] optionalTextLabels = new JLabel[]{new JLabel(I18n.tr((String)"City:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"State:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"Post Code:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"Country:", (Object[])new Object[0])), new JLabel(I18n.tr((String)"Full Address:", (Object[])new Object[0]))};
        this.cityTextField = new JTextField(lastCity, 100);
        this.stateTextField = new JTextField(lastState, 100);
        this.postCodeTextField = new JTextField(lastPostCode, 20);
        this.countryTextField = new JTextField(lastCountry, 2);
        this.fullTextField = new JTextField(lastFullAddress, 300);
        this.countryTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                JTextField jtextfield = (JTextField)e.getSource();
                String text = jtextfield.getText();
                int length = text.length();
                if (length == jtextfield.getColumns()) {
                    e.consume();
                } else if (length > jtextfield.getColumns()) {
                    e.consume();
                } else if (!e.isActionKey()) {
                    e.setKeyChar(Character.toUpperCase(e.getKeyChar()));
                }
            }
        });
        Component[] optionalEditFields = new Component[]{this.cityTextField, this.stateTextField, this.postCodeTextField, this.countryTextField, this.fullTextField};
        this.AddEditControlRows(optionalTextLabels, optionalEditFields, editControlsPane);
        JPanel optionPanel = new JPanel(new BorderLayout());
        Border groupBox = BorderFactory.createEtchedBorder();
        TitledBorder titleBorder = BorderFactory.createTitledBorder(groupBox, I18n.tr((String)"Optional Information:", (Object[])new Object[0]), 1, 2);
        optionPanel.setBorder(titleBorder);
        optionPanel.add((Component)editControlsPane, "Center");
        return optionPanel;
    }

    private void GetExistingMapKeys() {
        for (Node node : this.houseNumberNodes) {
            this.CheckNodeForAddressTags(node);
        }
        if (this.addrInterpolationWay != null) {
            String currentInclusion;
            String currentMethod = this.addrInterpolationWay.get("addr:interpolation");
            if (currentMethod != null) {
                this.SelectInterpolationMethod(currentMethod);
                this.interpolationMethodSet = true;
            }
            if ((currentInclusion = this.addrInterpolationWay.get("addr:inclusion")) != null) {
                this.SelectInclusion(currentInclusion);
            }
            Node firstNode = this.addrInterpolationWay.getNode(0);
            Node lastNode = this.addrInterpolationWay.getNode(this.addrInterpolationWay.getNodesCount() - 1);
            String value = firstNode.get("addr:housenumber");
            if (value != null) {
                this.startTextField.setText(value);
            }
            if ((value = lastNode.get("addr:housenumber")) != null) {
                this.endTextField.setText(value);
            }
            this.CheckNodeForAddressTags(firstNode);
            this.CheckNodeForAddressTags(lastNode);
        }
    }

    private void CheckNodeForAddressTags(Node checkNode) {
        String value = checkNode.get("addr:city");
        if (value != null) {
            lastCity = value;
        }
        if ((value = checkNode.get("addr:state")) != null) {
            lastState = value;
        }
        if ((value = checkNode.get("addr:postcode")) != null) {
            lastPostCode = value;
        }
        if ((value = checkNode.get("addr:country")) != null) {
            lastCountry = value;
        }
        if ((value = checkNode.get("addr:full")) != null) {
            lastFullAddress = value;
        }
    }

    private String FindRelation() {
        String relationDescription = null;
        DataSet currentDataSet = Main.main.getCurrentDataSet();
        if (currentDataSet != null) {
            for (Relation relation : currentDataSet.getRelations()) {
                String relationType = relation.get("type");
                if (relationType == null || !relationType.equals("associatedStreet")) continue;
                for (RelationMember relationMember : relation.getMembers()) {
                    Way way;
                    if (!relationMember.isWay() || (way = (Way)relationMember.getMember()) != this.selectedStreet) continue;
                    this.associatedStreetRelation = relation;
                    relationDescription = Long.toString(way.getId());
                    String streetName = "";
                    streetName = relation.getKeys().containsKey((Object)"name") ? relation.get("name") : this.selectedStreet.get("name");
                    relationDescription = relationDescription + " (" + streetName + ")";
                    return relationDescription;
                }
            }
        }
        return "";
    }

    private boolean FindAndSaveSelections() {
        boolean isValid = false;
        int namedWayCount = 0;
        int unNamedWayCount = 0;
        DataSet currentDataSet = Main.main.getCurrentDataSet();
        if (currentDataSet != null) {
            for (OsmPrimitive osm : currentDataSet.getSelectedWays()) {
                Way way = (Way)osm;
                if (way.getKeys().containsKey((Object)"name")) {
                    ++namedWayCount;
                    this.selectedStreet = way;
                    continue;
                }
                ++unNamedWayCount;
                this.addrInterpolationWay = way;
            }
            this.houseNumberNodes = new ArrayList();
            for (OsmPrimitive osm : currentDataSet.getSelectedNodes()) {
                Node node = (Node)osm;
                if (!node.getKeys().containsKey((Object)"addr:housenumber")) continue;
                this.houseNumberNodes.add(node);
            }
            if (this.addrInterpolationWay != null && this.addrInterpolationWay.getNodesCount() > 2) {
                for (int i = 1; i < this.addrInterpolationWay.getNodesCount() - 2; ++i) {
                    Node testNode = this.addrInterpolationWay.getNode(i);
                    if (!testNode.getKeys().containsKey((Object)"addr:housenumber")) continue;
                    this.houseNumberNodes.add(testNode);
                }
            }
        }
        if (namedWayCount != 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select a street to associate with address interpolation way", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        } else if (unNamedWayCount != 1) {
            if (this.houseNumberNodes.size() > 0) {
                isValid = true;
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select address interpolation way for this street", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            }
        } else {
            isValid = true;
        }
        return isValid;
    }

    private void AddEditControlRows(JLabel[] labels, Component[] editFields, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridx = 0;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 0.0;
            container.add((Component)labels[i], c);
            c.gridx = 1;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            container.add(editFields[i], c);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("ok".equals(e.getActionCommand())) {
            if (this.ValidateAndSave()) {
                this.dialog.dispose();
            }
        } else if ("cancel".equals(e.getActionCommand())) {
            this.dialog.dispose();
        }
    }

    private String BaseAlpha(String strValue) {
        if (strValue.length() > 0) {
            return strValue.substring(0, strValue.length() - 1);
        }
        return "";
    }

    private char LastChar(String strValue) {
        if (strValue.length() > 0) {
            return strValue.charAt(strValue.length() - 1);
        }
        return '\u0000';
    }

    private boolean isLong(String input) {
        try {
            Long val = Long.parseLong(input);
            return val > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isEven(Long input) {
        return input % 2L == 0L;
    }

    private static boolean IsNumeric(String s) {
        return p.matcher(s).matches();
    }

    private void InterpolateAlphaSection(int startNodeIndex, int endNodeIndex, String endValueString, char startingChar, char endingChar) {
        String baseAlpha = this.BaseAlpha(endValueString);
        int nSegments = endNodeIndex - startNodeIndex;
        double[] segmentLengths = new double[nSegments];
        double totalLength = this.CalculateSegmentLengths(startNodeIndex, endNodeIndex, segmentLengths);
        int nHouses = endingChar - startingChar - 1;
        if (nHouses > 0) {
            double houseSpacing = totalLength / (double)(nHouses + 1);
            Node lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex);
            int currentSegment = 0;
            char currentChar = startingChar;
            while (nHouses > 0) {
                double distanceNeeded;
                for (distanceNeeded = houseSpacing; distanceNeeded > segmentLengths[currentSegment]; distanceNeeded -= segmentLengths[currentSegment]) {
                    lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex + ++currentSegment);
                }
                double proportion = distanceNeeded / segmentLengths[currentSegment];
                Node toNode = this.addrInterpolationWay.getNode(startNodeIndex + 1 + currentSegment);
                LatLon newHouseNumberPosition = lastHouseNode.getCoor().interpolate(toNode.getCoor(), proportion);
                Node newHouseNumberNode = new Node(newHouseNumberPosition);
                if ((currentChar = (char)(currentChar + '\u0001')) > 'Z' && currentChar < 'a') {
                    currentChar = 'a';
                }
                String newHouseNumber = baseAlpha + currentChar;
                newHouseNumberNode.put("addr:housenumber", newHouseNumber);
                this.commandGroup.add((Command)new AddCommand((OsmPrimitive)newHouseNumberNode));
                this.houseNumberNodes.add(newHouseNumberNode);
                lastHouseNode = newHouseNumberNode;
                int n = currentSegment;
                segmentLengths[n] = segmentLengths[n] - distanceNeeded;
                --nHouses;
            }
        }
    }

    private void CreateAlphaInterpolation(String startValueString, String endValueString) {
        char startingChar = this.LastChar(startValueString);
        char endingChar = this.LastChar(endValueString);
        if (this.isLong(startValueString)) {
            startingChar = '@';
        }
        int startIndex = 0;
        for (int i = 1; i < this.addrInterpolationWay.getNodesCount() - 1; ++i) {
            char anchorChar;
            Node testNode = this.addrInterpolationWay.getNode(i);
            String endNodeNumber = testNode.get("addr:housenumber");
            if (endNodeNumber == null || endNodeNumber == "" || (anchorChar = this.LastChar(endNodeNumber)) <= startingChar || anchorChar >= endingChar) continue;
            this.InterpolateAlphaSection(startIndex, i, endNodeNumber, startingChar, anchorChar);
            startingChar = anchorChar;
            startValueString = endNodeNumber;
            startIndex = i;
        }
        this.InterpolateAlphaSection(startIndex, this.addrInterpolationWay.getNodesCount() - 1, endValueString, startingChar, endingChar);
    }

    private double CalculateSegmentLengths(int startNodeIndex, int endNodeIndex, double[] segmentLengths) {
        Node fromNode = this.addrInterpolationWay.getNode(startNodeIndex);
        double totalLength = 0.0;
        int nSegments = segmentLengths.length;
        for (int segment = 0; segment < nSegments; ++segment) {
            Node toNode = this.addrInterpolationWay.getNode(startNodeIndex + 1 + segment);
            segmentLengths[segment] = fromNode.getCoor().greatCircleDistance(toNode.getCoor());
            totalLength += segmentLengths[segment];
            fromNode = toNode;
        }
        return totalLength;
    }

    private void InterpolateNumericSection(int startNodeIndex, int endNodeIndex, long startingAddr, long endingAddr, long increment) {
        int nSegments = endNodeIndex - startNodeIndex;
        double[] segmentLengths = new double[nSegments];
        double totalLength = this.CalculateSegmentLengths(startNodeIndex, endNodeIndex, segmentLengths);
        int nHouses = (int)((endingAddr - startingAddr) / increment) - 1;
        if (nHouses > 0) {
            double houseSpacing = totalLength / (double)(nHouses + 1);
            Node lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex);
            int currentSegment = 0;
            long currentHouseNumber = startingAddr;
            while (nHouses > 0) {
                double distanceNeeded;
                for (distanceNeeded = houseSpacing; distanceNeeded > segmentLengths[currentSegment]; distanceNeeded -= segmentLengths[currentSegment]) {
                    lastHouseNode = this.addrInterpolationWay.getNode(startNodeIndex + ++currentSegment);
                }
                double proportion = distanceNeeded / segmentLengths[currentSegment];
                Node toNode = this.addrInterpolationWay.getNode(startNodeIndex + 1 + currentSegment);
                LatLon newHouseNumberPosition = lastHouseNode.getCoor().interpolate(toNode.getCoor(), proportion);
                Node newHouseNumberNode = new Node(newHouseNumberPosition);
                String newHouseNumber = Long.toString(currentHouseNumber += increment);
                newHouseNumberNode.put("addr:housenumber", newHouseNumber);
                this.commandGroup.add((Command)new AddCommand((OsmPrimitive)newHouseNumberNode));
                this.houseNumberNodes.add(newHouseNumberNode);
                lastHouseNode = newHouseNumberNode;
                int n = currentSegment;
                segmentLengths[n] = segmentLengths[n] - distanceNeeded;
                --nHouses;
            }
        }
    }

    private void CreateNumericInterpolation(String startValueString, String endValueString, long increment) {
        long startingAddr = Long.parseLong(startValueString);
        long endingAddr = Long.parseLong(endValueString);
        int startIndex = 0;
        for (int i = 1; i < this.addrInterpolationWay.getNodesCount() - 1; ++i) {
            long anchorAddrNumber;
            Node testNode = this.addrInterpolationWay.getNode(i);
            String strEndNodeNumber = testNode.get("addr:housenumber");
            if (strEndNodeNumber == null || !this.isLong(strEndNodeNumber) || (anchorAddrNumber = Long.parseLong(strEndNodeNumber)) <= startingAddr || anchorAddrNumber >= endingAddr) continue;
            this.InterpolateNumericSection(startIndex, i, startingAddr, anchorAddrNumber, increment);
            startingAddr = anchorAddrNumber;
            startValueString = strEndNodeNumber;
            startIndex = i;
        }
        this.InterpolateNumericSection(startIndex, this.addrInterpolationWay.getNodesCount() - 1, startingAddr, endingAddr, increment);
    }

    private void ConvertWayToHousenumbers(String selectedMethod, String startValueString, String endValueString, String incrementString) {
        if (selectedMethod.equals("alphabetic")) {
            this.CreateAlphaInterpolation(startValueString, endValueString);
        } else {
            long increment = 1L;
            if (selectedMethod.equals("odd") || selectedMethod.equals("even")) {
                increment = 2L;
            } else if (selectedMethod.equals("Numeric")) {
                increment = Long.parseLong(incrementString);
            }
            this.CreateNumericInterpolation(startValueString, endValueString, increment);
        }
        this.RemoveAddressInterpolationWay();
    }

    private void RemoveAddressInterpolationWay() {
        this.commandGroup.add((Command)new DeleteCommand((OsmPrimitive)this.addrInterpolationWay));
        for (int i = 1; i < this.addrInterpolationWay.getNodesCount() - 1; ++i) {
            Node testNode = this.addrInterpolationWay.getNode(i);
            if (testNode.hasKeys()) continue;
            this.commandGroup.add((Command)new DeleteCommand((OsmPrimitive)testNode));
        }
        this.addrInterpolationWay = null;
    }

    private boolean ValidateAndSave() {
        String startValueString = this.ReadTextField(this.startTextField);
        String endValueString = this.ReadTextField(this.endTextField);
        String incrementString = this.ReadTextField(this.incrementTextField);
        String city = this.ReadTextField(this.cityTextField);
        String state = this.ReadTextField(this.stateTextField);
        String postCode = this.ReadTextField(this.postCodeTextField);
        String country = this.ReadTextField(this.countryTextField);
        String fullAddress = this.ReadTextField(this.fullTextField);
        String selectedMethod = this.GetInterpolationMethod();
        if (this.addrInterpolationWay != null) {
            Long startAddr = 0L;
            Long endAddr = 0L;
            if (!selectedMethod.equals("alphabetic")) {
                Long[] addrArray = new Long[]{startAddr, endAddr};
                if (!this.ValidAddressNumbers(startValueString, endValueString, addrArray)) {
                    return false;
                }
                startAddr = addrArray[0];
                endAddr = addrArray[1];
            }
            String errorMessage = "";
            if (selectedMethod.equals("odd")) {
                if (this.isEven(startAddr) || this.isEven(endAddr)) {
                    errorMessage = I18n.tr((String)"Expected odd numbers for addresses", (Object[])new Object[0]);
                }
            } else if (selectedMethod.equals("even")) {
                if (!this.isEven(startAddr) || !this.isEven(endAddr)) {
                    errorMessage = I18n.tr((String)"Expected even numbers for addresses", (Object[])new Object[0]);
                }
            } else if (!selectedMethod.equals("all")) {
                if (selectedMethod.equals("alphabetic")) {
                    errorMessage = this.ValidateAlphaAddress(startValueString, endValueString);
                } else if (selectedMethod.equals("Numeric") && !this.ValidNumericIncrementString(incrementString, startAddr, endAddr)) {
                    errorMessage = I18n.tr((String)"Expected valid number for increment", (Object[])new Object[0]);
                }
            }
            if (!errorMessage.equals("")) {
                JOptionPane.showMessageDialog(Main.parent, errorMessage, I18n.tr((String)"Error", (Object[])new Object[0]), 0);
                return false;
            }
        }
        if (country != null && country.length() != 2) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Country code must be 2 letters", (Object[])new Object[0]), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            return false;
        }
        this.commandGroup = new LinkedList<Command>();
        String streetName = this.selectedStreet.get("name");
        if (this.addrInterpolationWay != null) {
            Node firstNode = this.addrInterpolationWay.getNode(0);
            Node lastNode = this.addrInterpolationWay.getNode(this.addrInterpolationWay.getNodesCount() - 1);
            DataSet currentDataSet = Main.main.getCurrentDataSet();
            if (currentDataSet != null) {
                currentDataSet.clearSelection(new PrimitiveId[]{this.addrInterpolationWay});
                currentDataSet.clearSelection(new PrimitiveId[]{lastNode});
            }
            String interpolationTagValue = selectedMethod;
            if (selectedMethod.equals("Numeric")) {
                interpolationTagValue = incrementString;
            }
            if (this.cbConvertToHouseNumbers.getState()) {
                this.ConvertWayToHousenumbers(selectedMethod, startValueString, endValueString, incrementString);
            } else {
                this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)this.addrInterpolationWay, "addr:interpolation", interpolationTagValue));
                this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)this.addrInterpolationWay, "addr:inclusion", this.GetInclusionMethod()));
            }
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)firstNode, "addr:housenumber", startValueString));
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)lastNode, "addr:housenumber", endValueString));
            this.houseNumberNodes.add(firstNode);
            this.houseNumberNodes.add(lastNode);
        }
        if (this.streetRelationButton.isSelected()) {
            if (this.associatedStreetRelation == null) {
                this.CreateRelation(streetName);
            }
            this.editedRelation = new Relation(this.associatedStreetRelation);
            if (this.addrInterpolationWay != null) {
                this.AddToRelation(this.associatedStreetRelation, (OsmPrimitive)this.addrInterpolationWay, "house");
            }
        }
        for (Node node : this.houseNumberNodes) {
            if (this.streetRelationButton.isSelected()) {
                this.AddToRelation(this.associatedStreetRelation, (OsmPrimitive)node, "house");
            }
            if (city != null || this.streetNameButton.isSelected()) {
                this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "addr:street", streetName));
            }
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "addr:city", city));
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "addr:state", state));
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "addr:postcode", postCode));
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "addr:country", country));
            this.commandGroup.add((Command)new ChangePropertyCommand((OsmPrimitive)node, "addr:full", fullAddress));
        }
        if (this.relationChanged) {
            this.commandGroup.add((Command)new ChangeCommand((OsmPrimitive)this.associatedStreetRelation, (OsmPrimitive)this.editedRelation));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Address Interpolation", (Object[])new Object[0]), this.commandGroup));
        Main.map.repaint();
        return true;
    }

    private boolean ValidNumericIncrementString(String incrementString, long startingAddr, long endingAddr) {
        if (!this.isLong(incrementString)) {
            return false;
        }
        long testIncrement = Long.parseLong(incrementString);
        if (testIncrement <= 0L || testIncrement > endingAddr) {
            return false;
        }
        return (endingAddr - startingAddr) % testIncrement == 0L;
    }

    private void CreateRelation(String streetName) {
        this.associatedStreetRelation = new Relation();
        this.associatedStreetRelation.put("name", streetName);
        this.associatedStreetRelation.put("type", "associatedStreet");
        RelationMember newStreetMember = new RelationMember("street", (OsmPrimitive)this.selectedStreet);
        this.associatedStreetRelation.addMember(newStreetMember);
        this.commandGroup.add((Command)new AddCommand((OsmPrimitive)this.associatedStreetRelation));
    }

    private String ReadTextField(JTextField field) {
        String value = field.getText();
        if (value != null && (value = value.trim()).equals("")) {
            value = null;
        }
        return value;
    }

    private void AddToRelation(Relation relation, OsmPrimitive testMember, String role) {
        boolean isFound = false;
        for (RelationMember relationMember : relation.getMembers()) {
            if (testMember != relationMember.getMember()) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            RelationMember newMember = new RelationMember(role, testMember);
            this.editedRelation.addMember(newMember);
            this.relationChanged = true;
        }
    }

    private String ValidateAlphaAddress(String startValueString, String endValueString) {
        String errorMessage = "";
        if (startValueString.equals("") || endValueString.equals("")) {
            errorMessage = I18n.tr((String)"Please enter valid number for starting and ending address", (Object[])new Object[0]);
        } else {
            char startingChar = this.LastChar(startValueString);
            char endingChar = this.LastChar(endValueString);
            boolean isOk = false;
            if (AddrInterpolationDialog.IsNumeric("" + startingChar) && !AddrInterpolationDialog.IsNumeric("" + endingChar)) {
                if ((endingChar = Character.toUpperCase(endingChar)) >= 'A' && endingChar <= 'Z') {
                    isOk = true;
                }
            } else if (!AddrInterpolationDialog.IsNumeric("" + startingChar) && !AddrInterpolationDialog.IsNumeric("" + endingChar)) {
                isOk = true;
            }
            if (!isOk) {
                errorMessage = I18n.tr((String)"Alphabetic address must end with a letter", (Object[])new Object[0]);
            }
            if (endValueString.length() > 1) {
                String numEnd;
                String numStart = this.BaseAlpha(startValueString);
                if (AddrInterpolationDialog.IsNumeric(startValueString)) {
                    numStart = startValueString;
                }
                if (!numStart.equals(numEnd = this.BaseAlpha(endValueString))) {
                    errorMessage = I18n.tr((String)"Starting and ending numbers must be the same for alphabetic addresses", (Object[])new Object[0]);
                }
            }
            if (startingChar >= endingChar) {
                errorMessage = I18n.tr((String)"Starting address letter must be less than ending address letter", (Object[])new Object[0]);
            }
        }
        return errorMessage;
    }

    private boolean ValidAddressNumbers(String startValueString, String endValueString, Long[] addrArray) {
        String errorMessage = "";
        if (!this.isLong(startValueString)) {
            errorMessage = I18n.tr((String)"Please enter valid number for starting address", (Object[])new Object[0]);
        }
        if (!this.isLong(endValueString)) {
            errorMessage = I18n.tr((String)"Please enter valid number for ending address", (Object[])new Object[0]);
        }
        if (errorMessage.equals("")) {
            addrArray[0] = Long.parseLong(startValueString);
            addrArray[1] = Long.parseLong(endValueString);
            if (addrArray[1] <= addrArray[0]) {
                errorMessage = I18n.tr((String)"Starting address number must be less than ending address number", (Object[])new Object[0]);
            }
        }
        if (errorMessage.equals("")) {
            return true;
        }
        JOptionPane.showMessageDialog(Main.parent, errorMessage, I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        return false;
    }

    private String GetInterpolationMethod() {
        int selectedIndex = this.addrInterpolationList.getSelectedIndex();
        return this.addrInterpolationTags[selectedIndex];
    }

    private String GetInclusionMethod() {
        int selectedIndex;
        lastAccuracyIndex = selectedIndex = this.addrInclusionList.getSelectedIndex();
        return this.addrInclusionTags[selectedIndex];
    }
}

