/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.apache.logging.log4j.core.util.Constants;

@Plugin(name="ExtendedThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"xEx", "xThrowable", "xException"})
public final class ExtendedThrowablePatternConverter
extends ThrowablePatternConverter {
    private ExtendedThrowablePatternConverter(String[] options) {
        super("ExtendedThrowable", "throwable", options);
    }

    public static ExtendedThrowablePatternConverter newInstance(String[] options) {
        return new ExtendedThrowablePatternConverter(options);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        Throwable throwable;
        ThrowableProxy proxy = null;
        if (event instanceof Log4jLogEvent) {
            proxy = event.getThrownProxy();
        }
        if (((throwable = event.getThrown()) != null || proxy != null) && this.options.anyLines()) {
            if (proxy == null) {
                super.format(event, toAppendTo);
                return;
            }
            String extStackTrace = proxy.getExtendedStackTraceAsString(this.options.getPackages());
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(' ');
            }
            if (!this.options.allLines() || !Constants.LINE_SEPARATOR.equals(this.options.getSeparator())) {
                StringBuilder sb = new StringBuilder();
                String[] array = extStackTrace.split(Constants.LINE_SEPARATOR);
                int limit = this.options.minLines(array.length) - 1;
                for (int i = 0; i <= limit; ++i) {
                    sb.append(array[i]);
                    if (i >= limit) continue;
                    sb.append(this.options.getSeparator());
                }
                toAppendTo.append(sb.toString());
            } else {
                toAppendTo.append(extStackTrace);
            }
        }
    }
}

