/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.mode;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.history.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandJoin;
import org.openstreetmap.josm.plugins.mapillary.history.commands.CommandUnjoin;
import org.openstreetmap.josm.plugins.mapillary.mode.AbstractMode;
import org.openstreetmap.josm.tools.I18n;

public class JoinMode
extends AbstractMode {
    private MapillaryImportedImage lastClick;
    private MouseEvent lastPos;

    public JoinMode() {
        this.cursor = 1;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.data.getHighlightedImage() == null) {
            return;
        }
        if (this.lastClick == null && this.data.getHighlightedImage() instanceof MapillaryImportedImage) {
            this.lastClick = (MapillaryImportedImage)this.data.getHighlightedImage();
        } else if (this.lastClick != null && this.data.getHighlightedImage() instanceof MapillaryImportedImage) {
            if ((this.data.getHighlightedImage().previous() == null && this.lastClick.next() == null || this.data.getHighlightedImage().next() == null && this.lastClick.previous() == null) && (this.data.getHighlightedImage().getSequence() != this.lastClick.getSequence() || this.lastClick.getSequence() == null)) {
                MapillaryRecord.getInstance().addCommand(new CommandJoin(Arrays.asList(this.lastClick, this.data.getHighlightedImage())));
            } else if (this.lastClick.next() == this.data.getHighlightedImage() || this.lastClick.previous() == this.data.getHighlightedImage()) {
                MapillaryRecord.getInstance().addCommand(new CommandUnjoin(Arrays.asList(this.lastClick, this.data.getHighlightedImage())));
            }
            this.lastClick = null;
        }
        MapillaryData.dataUpdated();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastPos = e;
        if (!(Main.map.mapView.getActiveLayer() instanceof MapillaryLayer)) {
            return;
        }
        MapillaryAbstractImage closestTemp = this.getClosest(e.getPoint());
        this.data.setHighlightedImage(closestTemp);
        MapillaryData.dataUpdated();
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        if (this.lastClick != null) {
            g.setColor(Color.WHITE);
            Point p0 = mv.getPoint(this.lastClick.getLatLon());
            Point p1 = this.lastPos.getPoint();
            g.drawLine(p0.x, p0.y, p1.x, p1.y);
        }
    }

    public String toString() {
        return I18n.tr((String)"Join mode", (Object[])new Object[0]);
    }
}

