/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryUploadDialog
extends JPanel {
    private static final long serialVersionUID = 2517368588113991767L;
    private JRadioButton sequence;
    private JCheckBox delete;

    public MapillaryUploadDialog() {
        this.setLayout(new BoxLayout(this, 3));
        if (MapillaryUser.getUsername() == null) {
            this.add(new JLabel(I18n.tr((String)"Go to setting and log in to Mapillary before uploading.", (Object[])new Object[0])));
        } else {
            ButtonGroup group = new ButtonGroup();
            this.sequence = new JRadioButton(I18n.tr((String)"Upload selected sequence", (Object[])new Object[0]));
            if (!(MapillaryLayer.getInstance().getData().getSelectedImage() instanceof MapillaryImportedImage)) {
                this.sequence.setEnabled(false);
            }
            group.add(this.sequence);
            this.add(this.sequence);
            group.setSelected(this.sequence.getModel(), true);
            this.delete = new JCheckBox(I18n.tr((String)"Delete after upload", (Object[])new Object[0]));
            this.delete.setSelected(Main.pref.getBoolean("mapillary.delete-after-upload", true));
            this.add(this.delete);
        }
    }

    public JCheckBox getDelete() {
        return this.delete;
    }

    public JRadioButton getSequence() {
        return this.sequence;
    }
}

