/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.io.download.MapillaryDownloader;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryLoginListener;
import org.openstreetmap.josm.plugins.mapillary.oauth.MapillaryUser;
import org.openstreetmap.josm.plugins.mapillary.oauth.OAuthPortListener;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryColorScheme;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryURL;
import org.openstreetmap.josm.plugins.mapillary.utils.MapillaryUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryPreferenceSetting
implements SubPreferenceSetting,
MapillaryLoginListener {
    private final JCheckBox reverseButtons = new JCheckBox(I18n.tr((String)"Reverse buttons position when displaying images.", (Object[])new Object[0]));
    private final JComboBox<String> downloadModeComboBox = new JComboBox<String>(new String[]{MapillaryDownloader.MODES.Automatic.toString(), MapillaryDownloader.MODES.Semiautomatic.toString(), MapillaryDownloader.MODES.Manual.toString()});
    private final JCheckBox displayHour = new JCheckBox(I18n.tr((String)"Display hour when the picture was taken", (Object[])new Object[0]));
    private final JCheckBox format24 = new JCheckBox(I18n.tr((String)"Use 24 hour format", (Object[])new Object[0]));
    private final JCheckBox moveTo = new JCheckBox(I18n.tr((String)"Move to picture''s location with next/previous buttons", (Object[])new Object[0]));
    private final JButton loginButton = new MapillaryColorScheme.MapillaryButton(I18n.tr((String)"Login", (Object[])new Object[0]), new LoginAction(this));
    private final JButton logoutButton = new MapillaryColorScheme.MapillaryButton(I18n.tr((String)"Logout", (Object[])new Object[0]), new LogoutAction());
    private final JLabel loginLabel = new JLabel();
    private final JPanel loginPanel = new JPanel();

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return gui.getDisplayPreference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGui(PreferenceTabbedPane gui) {
        JPanel container = new JPanel(new BorderLayout());
        this.loginPanel.setLayout(new BoxLayout(this.loginPanel, 2));
        this.loginPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.loginPanel.setBackground(MapillaryColorScheme.TOOLBAR_DARK_GREY);
        JLabel brandImage = new JLabel();
        try (InputStream is = MapillaryPreferenceSetting.class.getResourceAsStream("/images/mapillary-logo-white.png");){
            if (is != null) {
                brandImage.setIcon(new ImageIcon(ImageIO.read(is)));
            } else {
                Main.warn((String)"Could not load Mapillary brand image!");
            }
        }
        catch (IOException e) {
            Main.warn((String)"While reading Mapillary brand image, an IO-exception occured!");
        }
        this.loginPanel.add((Component)brandImage, 0);
        this.loginPanel.add(Box.createHorizontalGlue(), 1);
        this.loginLabel.setForeground(Color.WHITE);
        this.loginLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.loginPanel.add((Component)this.loginLabel, 2);
        this.loginPanel.add((Component)this.loginButton, 3);
        this.onLogout();
        container.add((Component)this.loginPanel, "North");
        JPanel mainPanel = new JPanel();
        this.reverseButtons.setSelected(Main.pref.getBoolean("mapillary.reverse-buttons"));
        this.displayHour.setSelected(Main.pref.getBoolean("mapillary.display-hour", true));
        this.format24.setSelected(Main.pref.getBoolean("mapillary.format-24"));
        this.moveTo.setSelected(Main.pref.getBoolean("mapillary.move-to-picture", true));
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String downloadMode = Main.pref.get("mapillary.download-mode");
        if (MapillaryDownloader.MODES.Automatic.toString().equals(downloadMode) || MapillaryDownloader.MODES.Semiautomatic.toString().equals(downloadMode) || MapillaryDownloader.MODES.Manual.toString().equals(downloadMode)) {
            this.downloadModeComboBox.setSelectedItem(Main.pref.get("mapillary.download-mode"));
        }
        JPanel downloadModePanel = new JPanel();
        downloadModePanel.add(new JLabel(I18n.tr((String)"Download mode", (Object[])new Object[0])));
        downloadModePanel.add(this.downloadModeComboBox);
        mainPanel.add((Component)downloadModePanel, GBC.eol());
        mainPanel.add((Component)this.reverseButtons, GBC.eol());
        mainPanel.add((Component)this.displayHour, GBC.eol());
        mainPanel.add((Component)this.format24, GBC.eol());
        mainPanel.add((Component)this.moveTo, GBC.eol());
        MapillaryColorScheme.styleAsDefaultPanel(mainPanel, downloadModePanel, this.reverseButtons, this.displayHour, this.format24, this.moveTo);
        mainPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        container.add((Component)mainPanel, "Center");
        JTabbedPane jTabbedPane = gui.getDisplayPreference().getTabPane();
        synchronized (jTabbedPane) {
            gui.getDisplayPreference().addSubTab((SubPreferenceSetting)this, "Mapillary", (Component)new JScrollPane(container));
            gui.getDisplayPreference().getTabPane().setIconAt(gui.getDisplayPreference().getTabPane().getTabCount() - 1, MapillaryPlugin.ICON12);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                String username = MapillaryUser.getUsername();
                if (username != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MapillaryPreferenceSetting.this.onLogin(MapillaryUser.getUsername());
                        }
                    });
                }
            }
        }).start();
    }

    @Override
    public void onLogin(String username) {
        this.loginPanel.remove(this.loginButton);
        this.loginPanel.add((Component)this.logoutButton, 3);
        this.loginLabel.setText(I18n.tr((String)"You are logged in as ''{0}''.", (Object[])new Object[]{username}));
        this.loginPanel.revalidate();
        this.loginPanel.repaint();
    }

    @Override
    public void onLogout() {
        this.loginPanel.remove(this.logoutButton);
        this.loginPanel.add((Component)this.loginButton, 3);
        this.loginLabel.setText(I18n.tr((String)"You are currently not logged in.", (Object[])new Object[0]));
        this.loginPanel.revalidate();
        this.loginPanel.repaint();
    }

    public boolean ok() {
        boolean mod = false;
        Main.pref.put("mapillary.reverse-buttons", this.reverseButtons.isSelected());
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getDownloadViewMenu(), false);
        if (this.downloadModeComboBox.getSelectedItem().equals(MapillaryDownloader.MODES.Automatic.toString())) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES.Automatic.toString());
        }
        if (this.downloadModeComboBox.getSelectedItem().equals(MapillaryDownloader.MODES.Semiautomatic.toString())) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES.Semiautomatic.toString());
        }
        if (this.downloadModeComboBox.getSelectedItem().equals(MapillaryDownloader.MODES.Manual.toString())) {
            Main.pref.put("mapillary.download-mode", MapillaryDownloader.MODES.Manual.toString());
            MapillaryPlugin.setMenuEnabled(MapillaryPlugin.getDownloadViewMenu(), true);
        }
        Main.pref.put("mapillary.display-hour", this.displayHour.isSelected());
        Main.pref.put("mapillary.format-24", this.format24.isSelected());
        Main.pref.put("mapillary.move-to-picture", this.moveTo.isSelected());
        return mod;
    }

    public boolean isExpert() {
        return false;
    }

    public class LogoutAction
    extends AbstractAction {
        private static final long serialVersionUID = 3434780936404707219L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MapillaryUser.reset();
            Main.pref.put("mapillary.access-token", null);
            MapillaryPreferenceSetting.this.onLogout();
        }
    }

    public class LoginAction
    extends AbstractAction {
        private static final long serialVersionUID = -3908477563072057344L;
        private final transient MapillaryLoginListener callback;

        public LoginAction(MapillaryLoginListener loginCallback) {
            this.callback = loginCallback;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            OAuthPortListener portListener = new OAuthPortListener(this.callback);
            portListener.start();
            try {
                MapillaryUtils.browse(MapillaryURL.connectURL("http://localhost:8763/"));
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
    }
}

