/*
 * Decompiled with CFR 0.152.
 */
package cadastre_fr;

import cadastre_fr.ImageModifier;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.ColorHelper;

public class VectorImageModifier
extends ImageModifier {
    private int cadastreBackground = -1;
    public static int cadastreBackgroundTransp = 1;
    private int backgroundPixel = 0;

    public VectorImageModifier() {
    }

    public VectorImageModifier(BufferedImage bi, boolean monocolor) {
        this.bufferedImage = bi;
        if (Main.pref.getBoolean("cadastrewms.backgroundTransparent")) {
            this.makeTransparent();
        } else if (Main.pref.getBoolean("cadastrewms.alterColors")) {
            this.replaceBackground();
        }
        if (Main.pref.getBoolean("cadastrewms.invertGrey")) {
            this.invertGrey();
        }
        if (monocolor) {
            this.bufferedImage = this.convert8(this.convert4(this.bufferedImage));
        }
    }

    private void replaceBackground() {
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        int josmBackgroundColor = ColorHelper.html2color((String)Main.pref.get("color.background", "#000000")).getRGB();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel = this.bufferedImage.getRGB(x, y);
                if (pixel != this.cadastreBackground) continue;
                this.bufferedImage.setRGB(x, y, josmBackgroundColor);
            }
        }
        this.cadastreBackground = josmBackgroundColor;
    }

    private void invertGrey() {
        int w = this.bufferedImage.getWidth();
        int h = this.bufferedImage.getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel = this.bufferedImage.getRGB(x, y);
                if (pixel == this.cadastreBackground) continue;
                this.bufferedImage.setRGB(x, y, this.reverseIfGrey(pixel));
            }
        }
    }

    private int reverseIfGrey(int pixel) {
        Color col = new Color(pixel);
        int r = col.getRed();
        int g = col.getGreen();
        int b = col.getBlue();
        if (b == r && b == g) {
            pixel = ((byte)col.getAlpha() << 24) + ((byte)(255 - r) << 16) + ((byte)(255 - r) << 8) + (byte)(255 - r);
        }
        return pixel;
    }

    private void makeTransparent() {
        ColorModel colorModel = this.bufferedImage.getColorModel();
        if (this.bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            WritableRaster raster = this.bufferedImage.getRaster();
            this.backgroundPixel = 1;
            int size = icm.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            icm.getReds(reds);
            icm.getGreens(greens);
            icm.getBlues(blues);
            this.cadastreBackground = 0xFFFFFF;
            IndexColorModel icm2 = new IndexColorModel(colorModel.getPixelSize(), size, reds, greens, blues, this.backgroundPixel);
            this.bufferedImage = new BufferedImage(icm2, raster, this.bufferedImage.isAlphaPremultiplied(), null);
        }
    }
}

