/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.affine;

import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.piclayer.actions.GenericPicTransformAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MovePointAction
extends GenericPicTransformAction {
    public MovePointAction(MapFrame frame) {
        super(I18n.tr((String)"PicLayer Move point", (Object[])new Object[0]), I18n.tr((String)"Point added/moved", (Object[])new Object[0]), "movepoint", I18n.tr((String)"Drag or create point on the picture", (Object[])new Object[0]), frame, ImageProvider.getCursor((String)"crosshair", null));
    }

    @Override
    protected void doAction(MouseEvent e) {
        try {
            Point2D pressed = this.currentLayer.transformPoint(e.getPoint());
            if (this.selectedPoint != null) {
                this.currentLayer.getTransformer().replaceOriginPoint(this.selectedPoint, pressed);
                this.selectedPoint = pressed;
            }
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.currentLayer == null) {
            return;
        }
        try {
            Point2D pressed = this.currentLayer.transformPoint(e.getPoint());
            if (this.selectedPoint == null) {
                this.currentLayer.getTransformer().addOriginPoint(pressed);
            }
            this.currentCommand.addIfChanged();
        }
        catch (NoninvertibleTransformException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.updateDrawPoints(true);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.updateDrawPoints(false);
    }
}

