/*
 * Decompiled with CFR 0.152.
 */
package gpxfilter;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.xml.sax.SAXException;

public class GpxGrabber
extends OsmServerReader {
    private final double lat1;
    private final double lon1;
    private final double lat2;
    private final double lon2;
    private int page;

    public GpxGrabber(Bounds downloadArea) {
        this.lat1 = downloadArea.getMin().lat();
        this.lon1 = downloadArea.getMin().lon();
        this.lat2 = downloadArea.getMax().lat();
        this.lon2 = downloadArea.getMax().lon();
        this.page = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GpxData parseRawGps() throws IOException, SAXException, OsmTransferException {
        String url = "trackpoints?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=" + this.page;
        try (InputStream in = this.getInputStream(url, NullProgressMonitor.INSTANCE);){
            GpxReader reader = new GpxReader(in);
            reader.parse(false);
            GpxData result = reader.getGpxData();
            result.fromServer = true;
            ++this.page;
            GpxData gpxData = result;
            return gpxData;
        }
        catch (IllegalArgumentException e) {
            if (!this.cancel) throw new SAXException("Illegal characters within the HTTP-header response.", e);
            return null;
        }
        catch (IOException e) {
            if (!this.cancel) throw e;
            return null;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (!this.cancel) throw e;
            return null;
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }
}

