/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.proj4j;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.I18n;
import org.osgeo.proj4j.CRSFactory;
import org.osgeo.proj4j.CoordinateReferenceSystem;
import org.osgeo.proj4j.CoordinateTransform;
import org.osgeo.proj4j.CoordinateTransformFactory;
import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.proj.Projection;

public class Proj4JProjection
implements org.openstreetmap.josm.data.projection.Projection {
    private String crsCode;
    private CoordinateTransform transformToWGS84;
    private CoordinateTransform transformFromWGS84;
    private CoordinateReferenceSystem proj4jCRS;
    private CoordinateReferenceSystem wgs84CRS;

    public Proj4JProjection(String crsCode) {
        this.crsCode = crsCode;
        CRSFactory crsFactory = new CRSFactory();
        CoordinateTransformFactory transFactory = new CoordinateTransformFactory();
        this.proj4jCRS = crsFactory.createFromName(crsCode);
        this.wgs84CRS = crsFactory.createFromName("EPSG:4326");
        this.transformToWGS84 = transFactory.createTransform(this.proj4jCRS, this.wgs84CRS);
        this.transformFromWGS84 = transFactory.createTransform(this.wgs84CRS, this.proj4jCRS);
    }

    public double getDefaultZoomInPPD() {
        return 1.01;
    }

    public EastNorth latlon2eastNorth(LatLon p) {
        ProjCoordinate pc1 = new ProjCoordinate(p.lon(), p.lat());
        ProjCoordinate pc2 = new ProjCoordinate();
        this.transformFromWGS84.transform(pc1, pc2);
        return new EastNorth(pc2.x, pc2.y);
    }

    public LatLon eastNorth2latlon(EastNorth p) {
        ProjCoordinate pc1 = new ProjCoordinate(p.east(), p.north());
        ProjCoordinate pc2 = new ProjCoordinate();
        this.transformToWGS84.transform(pc1, pc2);
        return new LatLon(pc2.y, pc2.x);
    }

    public String toString() {
        return I18n.tr((String)"Proj4J: {0} selected", (Object[])new Object[]{this.crsCode});
    }

    public String toCode() {
        return this.crsCode;
    }

    public String getCacheDirectoryName() {
        return "Proj4J";
    }

    public ProjectionBounds getWorldBoundsBoxEastNorth() {
        Bounds b = this.getWorldBoundsLatLon();
        ProjectionBounds result = new ProjectionBounds(this.latlon2eastNorth(b.getMin()));
        result.extend(this.latlon2eastNorth(b.getMax()));
        result.extend(this.latlon2eastNorth(new LatLon(b.getMinLat(), b.getMaxLon())));
        result.extend(this.latlon2eastNorth(new LatLon(b.getMaxLat(), b.getMinLon())));
        double dLon = (b.getMaxLon() - b.getMinLon()) / 1000.0;
        double dLat = (b.getMaxLat() - b.getMinLat()) / 1000.0;
        for (double lon = b.getMinLon(); lon < b.getMaxLon(); lon += dLon) {
            result.extend(this.latlon2eastNorth(new LatLon(b.getMinLat(), lon)));
            result.extend(this.latlon2eastNorth(new LatLon(b.getMaxLat(), lon)));
        }
        for (double lat = b.getMinLat(); lat < b.getMaxLat(); lat += dLat) {
            result.extend(this.latlon2eastNorth(new LatLon(lat, b.getMinLon())));
            result.extend(this.latlon2eastNorth(new LatLon(lat, b.getMaxLon())));
        }
        return result;
    }

    public Bounds getWorldBoundsLatLon() {
        Projection proj = this.proj4jCRS.getProjection();
        LatLon min = new LatLon(proj.getMinLatitudeDegrees(), proj.getMinLongitudeDegrees());
        LatLon max = new LatLon(proj.getMaxLatitudeDegrees(), proj.getMaxLongitudeDegrees());
        return new Bounds(min, max, true);
    }

    public double getMetersPerUnit() {
        return 1.0 / this.proj4jCRS.getProjection().getFromMetres();
    }

    public boolean switchXY() {
        return false;
    }

    public Bounds getLatLonBoundsBox(ProjectionBounds r) {
        Bounds result = new Bounds(this.eastNorth2latlon(r.getMin()));
        result.extend(this.eastNorth2latlon(r.getMax()));
        int N = 40;
        double dEast = (r.maxEast - r.minEast) / 40.0;
        double dNorth = (r.maxNorth - r.minNorth) / 40.0;
        for (int i = 0; i <= 40; ++i) {
            result.extend(this.eastNorth2latlon(new EastNorth(r.minEast + (double)i * dEast, r.minNorth)));
            result.extend(this.eastNorth2latlon(new EastNorth(r.minEast + (double)i * dEast, r.maxNorth)));
            result.extend(this.eastNorth2latlon(new EastNorth(r.minEast, r.minNorth + (double)i * dNorth)));
            result.extend(this.eastNorth2latlon(new EastNorth(r.maxEast, r.minNorth + (double)i * dNorth)));
        }
        return result;
    }
}

