/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import org.openstreetmap.josm.actions.search.PushbackTokenizer;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public abstract class RangeMatch
extends SearchCompiler.Match {
    private final long min;
    private final long max;

    public RangeMatch(long min, long max) {
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    public RangeMatch(PushbackTokenizer.Range range) {
        this(range.getStart(), range.getEnd());
    }

    protected abstract Long getNumber(OsmPrimitive var1);

    protected abstract String getString();

    public boolean match(OsmPrimitive osm) {
        Long num = this.getNumber(osm);
        if (num == null) {
            return false;
        }
        return num >= this.min && num <= this.max;
    }

    public String toString() {
        return this.getString() + "=" + this.min + "-" + this.max;
    }
}

