/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.icc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.icc.IccTagDataType;
import org.apache.commons.imaging.icc.IccTagDataTypes;
import org.apache.commons.imaging.icc.IccTagType;
import org.apache.commons.imaging.util.IoUtils;

public class IccTag {
    public final int signature;
    public final int offset;
    public final int length;
    public final IccTagType fIccTagType;
    private byte[] data;
    private IccTagDataType itdt;
    private int dataTypeSignature;

    public IccTag(int signature, int offset, int length, IccTagType fIccTagType) {
        this.signature = signature;
        this.offset = offset;
        this.length = length;
        this.fIccTagType = fIccTagType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(byte[] bytes) throws IOException {
        this.data = bytes;
        ByteArrayInputStream bis = null;
        boolean canThrow = false;
        try {
            bis = new ByteArrayInputStream(bytes);
            this.dataTypeSignature = BinaryFunctions.read4Bytes("data type signature", bis, "ICC: corrupt tag data", ByteOrder.BIG_ENDIAN);
            this.itdt = this.getIccTagDataType(this.dataTypeSignature);
            canThrow = true;
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(canThrow, bis);
            throw throwable;
        }
        IoUtils.closeQuietly(canThrow, bis);
    }

    private IccTagDataType getIccTagDataType(int quad) {
        for (IccTagDataTypes iccTagDataType : IccTagDataTypes.values()) {
            if (iccTagDataType.getSignature() != quad) continue;
            return iccTagDataType;
        }
        return null;
    }

    public void dump(String prefix) throws ImageReadException, IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset()));
        this.dump(pw, prefix);
        pw.flush();
    }

    public void dump(PrintWriter pw, String prefix) throws ImageReadException, IOException {
        pw.println(prefix + "tag signature: " + Integer.toHexString(this.signature) + " (" + new String(new byte[]{(byte)(0xFF & this.signature >> 24), (byte)(0xFF & this.signature >> 16), (byte)(0xFF & this.signature >> 8), (byte)(0xFF & this.signature >> 0)}, "US-ASCII") + ")");
        if (this.data == null) {
            pw.println(prefix + "data: " + Arrays.toString(this.data));
        } else {
            pw.println(prefix + "data: " + this.data.length);
            pw.println(prefix + "data type signature: " + Integer.toHexString(this.dataTypeSignature) + " (" + new String(new byte[]{(byte)(0xFF & this.dataTypeSignature >> 24), (byte)(0xFF & this.dataTypeSignature >> 16), (byte)(0xFF & this.dataTypeSignature >> 8), (byte)(0xFF & this.dataTypeSignature >> 0)}, "US-ASCII") + ")");
            if (this.itdt == null) {
                pw.println(prefix + "IccTagType : " + "unknown");
            } else {
                pw.println(prefix + "IccTagType : " + this.itdt.getName());
                this.itdt.dump(prefix, this.data);
            }
        }
        pw.println("");
        pw.flush();
    }
}

