/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.equation.ManagerTempVariables;
import org.ejml.equation.Variable;
import org.ejml.equation.VariableMatrix;
import org.ejml.equation.VariableScalar;
import org.ejml.ops.CommonOps;

public class MatrixConstructor {
    VariableMatrix output;
    List<Item> items = new ArrayList<Item>();
    List<VariableScalar> tmp = new ArrayList<VariableScalar>();

    public MatrixConstructor(ManagerTempVariables manager) {
        this.output = manager.createMatrix();
    }

    public void addToRow(Variable variable) {
        this.items.add(new Item(variable));
    }

    public void endRow() {
        this.items.add(new Item());
    }

    public void construct() {
        if (!this.items.get((int)(this.items.size() - 1)).endRow) {
            this.endRow();
        }
        this.setToRequiredSize(this.output.matrix);
        int matrixRow = 0;
        ArrayList<Item> row = new ArrayList<Item>();
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            if (item.endRow) {
                Item v = (Item)row.get(0);
                int numRows = v.getRows();
                int numCols = v.getColumns();
                if (v.matrix) {
                    CommonOps.insert(v.getMatrix(), this.output.matrix, matrixRow, 0);
                } else {
                    this.output.matrix.set(matrixRow, 0, v.getValue());
                }
                for (int j = 1; j < row.size(); ++j) {
                    v = (Item)row.get(j);
                    if (v.getRows() != numRows) {
                        throw new RuntimeException("Row miss-matched. " + numRows + " " + v.getRows());
                    }
                    if (v.matrix) {
                        CommonOps.insert(v.getMatrix(), this.output.matrix, matrixRow, numCols);
                    } else {
                        this.output.matrix.set(matrixRow, numCols, v.getValue());
                    }
                    numCols += v.getColumns();
                }
                matrixRow += numRows;
                row.clear();
                continue;
            }
            row.add(item);
        }
    }

    public VariableMatrix getOutput() {
        return this.output;
    }

    protected void setToRequiredSize(DenseMatrix64F matrix) {
        int matrixRow = 0;
        int matrixCol = 0;
        ArrayList<Item> row = new ArrayList<Item>();
        for (int i = 0; i < this.items.size(); ++i) {
            Item item = this.items.get(i);
            if (item.endRow) {
                Item v = (Item)row.get(0);
                int numRows = v.getRows();
                int numCols = v.getColumns();
                for (int j = 1; j < row.size(); ++j) {
                    v = (Item)row.get(j);
                    if (v.getRows() != numRows) {
                        throw new RuntimeException("Row miss-matched. " + numRows + " " + v.getRows());
                    }
                    numCols += v.getColumns();
                }
                matrixRow += numRows;
                if (matrixCol == 0) {
                    matrixCol = numCols;
                } else if (matrixCol != numCols) {
                    throw new RuntimeException("Unexpected number of columns");
                }
                row.clear();
                continue;
            }
            row.add(item);
        }
        matrix.reshape(matrixRow, matrixCol);
    }

    private static class Item {
        Variable variable;
        boolean endRow;
        boolean matrix;

        private Item(Variable variable) {
            this.variable = variable;
            this.matrix = variable instanceof VariableMatrix;
        }

        private Item() {
            this.endRow = true;
        }

        public int getRows() {
            if (this.matrix) {
                return ((VariableMatrix)this.variable).matrix.numRows;
            }
            return 1;
        }

        public int getColumns() {
            if (this.matrix) {
                return ((VariableMatrix)this.variable).matrix.numCols;
            }
            return 1;
        }

        public DenseMatrix64F getMatrix() {
            return ((VariableMatrix)this.variable).matrix;
        }

        public double getValue() {
            return ((VariableScalar)this.variable).getDouble();
        }
    }
}

