/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndianOutput;

public final class ExtendedFormatRecord
extends StandardRecord {
    public static final short sid = 224;
    public static final short XF_STYLE = 1;
    public static final short XF_CELL = 0;
    private short field_1_font_index;
    private short field_2_format_index;
    private static final BitField _locked = BitFieldFactory.getInstance(1);
    private static final BitField _hidden = BitFieldFactory.getInstance(2);
    private static final BitField _xf_type = BitFieldFactory.getInstance(4);
    private static final BitField _parent_index = BitFieldFactory.getInstance(65520);
    private short field_3_cell_options;
    private static final BitField _alignment = BitFieldFactory.getInstance(7);
    private static final BitField _wrap_text = BitFieldFactory.getInstance(8);
    private static final BitField _vertical_alignment = BitFieldFactory.getInstance(112);
    private static final BitField _justify_last = BitFieldFactory.getInstance(128);
    private static final BitField _rotation = BitFieldFactory.getInstance(65280);
    private short field_4_alignment_options;
    private static final BitField _indent = BitFieldFactory.getInstance(15);
    private static final BitField _shrink_to_fit = BitFieldFactory.getInstance(16);
    private static final BitField _merge_cells = BitFieldFactory.getInstance(32);
    private static final BitField _reading_order = BitFieldFactory.getInstance(192);
    private static final BitField _indent_not_parent_format = BitFieldFactory.getInstance(1024);
    private static final BitField _indent_not_parent_font = BitFieldFactory.getInstance(2048);
    private static final BitField _indent_not_parent_alignment = BitFieldFactory.getInstance(4096);
    private static final BitField _indent_not_parent_border = BitFieldFactory.getInstance(8192);
    private static final BitField _indent_not_parent_pattern = BitFieldFactory.getInstance(16384);
    private static final BitField _indent_not_parent_cell_options = BitFieldFactory.getInstance(32768);
    private short field_5_indention_options;
    private static final BitField _border_left = BitFieldFactory.getInstance(15);
    private static final BitField _border_right = BitFieldFactory.getInstance(240);
    private static final BitField _border_top = BitFieldFactory.getInstance(3840);
    private static final BitField _border_bottom = BitFieldFactory.getInstance(61440);
    private short field_6_border_options;
    private static final BitField _left_border_palette_idx = BitFieldFactory.getInstance(127);
    private static final BitField _right_border_palette_idx = BitFieldFactory.getInstance(16256);
    private static final BitField _diag = BitFieldFactory.getInstance(49152);
    private short field_7_palette_options;
    private static final BitField _top_border_palette_idx = BitFieldFactory.getInstance(127);
    private static final BitField _bottom_border_palette_idx = BitFieldFactory.getInstance(16256);
    private static final BitField _adtl_diag = BitFieldFactory.getInstance(2080768);
    private static final BitField _adtl_diag_line_style = BitFieldFactory.getInstance(0x1E00000);
    private static final BitField _adtl_fill_pattern = BitFieldFactory.getInstance(-67108864);
    private int field_8_adtl_palette_options;
    private static final BitField _fill_foreground = BitFieldFactory.getInstance(127);
    private static final BitField _fill_background = BitFieldFactory.getInstance(16256);
    private short field_9_fill_palette_options;

    public ExtendedFormatRecord() {
    }

    public ExtendedFormatRecord(RecordInputStream recordInputStream) {
        this.field_1_font_index = recordInputStream.readShort();
        this.field_2_format_index = recordInputStream.readShort();
        this.field_3_cell_options = recordInputStream.readShort();
        this.field_4_alignment_options = recordInputStream.readShort();
        this.field_5_indention_options = recordInputStream.readShort();
        this.field_6_border_options = recordInputStream.readShort();
        this.field_7_palette_options = recordInputStream.readShort();
        this.field_8_adtl_palette_options = recordInputStream.readInt();
        this.field_9_fill_palette_options = recordInputStream.readShort();
    }

    public short getFontIndex() {
        return this.field_1_font_index;
    }

    public short getFormatIndex() {
        return this.field_2_format_index;
    }

    public short getCellOptions() {
        return this.field_3_cell_options;
    }

    public boolean isLocked() {
        return _locked.isSet(this.field_3_cell_options);
    }

    public boolean isHidden() {
        return _hidden.isSet(this.field_3_cell_options);
    }

    public short getXFType() {
        return _xf_type.getShortValue(this.field_3_cell_options);
    }

    public short getParentIndex() {
        return _parent_index.getShortValue(this.field_3_cell_options);
    }

    public short getAlignmentOptions() {
        return this.field_4_alignment_options;
    }

    public short getAlignment() {
        return _alignment.getShortValue(this.field_4_alignment_options);
    }

    public boolean getWrapText() {
        return _wrap_text.isSet(this.field_4_alignment_options);
    }

    public short getVerticalAlignment() {
        return _vertical_alignment.getShortValue(this.field_4_alignment_options);
    }

    public short getJustifyLast() {
        return _justify_last.getShortValue(this.field_4_alignment_options);
    }

    public short getRotation() {
        return _rotation.getShortValue(this.field_4_alignment_options);
    }

    public short getIndentionOptions() {
        return this.field_5_indention_options;
    }

    public short getIndent() {
        return _indent.getShortValue(this.field_5_indention_options);
    }

    public boolean getShrinkToFit() {
        return _shrink_to_fit.isSet(this.field_5_indention_options);
    }

    public boolean getMergeCells() {
        return _merge_cells.isSet(this.field_5_indention_options);
    }

    public short getReadingOrder() {
        return _reading_order.getShortValue(this.field_5_indention_options);
    }

    public boolean isIndentNotParentFormat() {
        return _indent_not_parent_format.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentFont() {
        return _indent_not_parent_font.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentAlignment() {
        return _indent_not_parent_alignment.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentBorder() {
        return _indent_not_parent_border.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentPattern() {
        return _indent_not_parent_pattern.isSet(this.field_5_indention_options);
    }

    public boolean isIndentNotParentCellOptions() {
        return _indent_not_parent_cell_options.isSet(this.field_5_indention_options);
    }

    public short getBorderOptions() {
        return this.field_6_border_options;
    }

    public short getBorderLeft() {
        return _border_left.getShortValue(this.field_6_border_options);
    }

    public short getBorderRight() {
        return _border_right.getShortValue(this.field_6_border_options);
    }

    public short getBorderTop() {
        return _border_top.getShortValue(this.field_6_border_options);
    }

    public short getBorderBottom() {
        return _border_bottom.getShortValue(this.field_6_border_options);
    }

    public short getPaletteOptions() {
        return this.field_7_palette_options;
    }

    public short getLeftBorderPaletteIdx() {
        return _left_border_palette_idx.getShortValue(this.field_7_palette_options);
    }

    public short getRightBorderPaletteIdx() {
        return _right_border_palette_idx.getShortValue(this.field_7_palette_options);
    }

    public short getDiag() {
        return _diag.getShortValue(this.field_7_palette_options);
    }

    public int getAdtlPaletteOptions() {
        return this.field_8_adtl_palette_options;
    }

    public short getTopBorderPaletteIdx() {
        return (short)_top_border_palette_idx.getValue(this.field_8_adtl_palette_options);
    }

    public short getBottomBorderPaletteIdx() {
        return (short)_bottom_border_palette_idx.getValue(this.field_8_adtl_palette_options);
    }

    public short getAdtlDiag() {
        return (short)_adtl_diag.getValue(this.field_8_adtl_palette_options);
    }

    public short getAdtlDiagLineStyle() {
        return (short)_adtl_diag_line_style.getValue(this.field_8_adtl_palette_options);
    }

    public short getAdtlFillPattern() {
        return (short)_adtl_fill_pattern.getValue(this.field_8_adtl_palette_options);
    }

    public short getFillPaletteOptions() {
        return this.field_9_fill_palette_options;
    }

    public short getFillForeground() {
        return _fill_foreground.getShortValue(this.field_9_fill_palette_options);
    }

    public short getFillBackground() {
        return _fill_background.getShortValue(this.field_9_fill_palette_options);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXTENDEDFORMAT]\n");
        if (this.getXFType() == 1) {
            stringBuffer.append(" STYLE_RECORD_TYPE\n");
        } else if (this.getXFType() == 0) {
            stringBuffer.append(" CELL_RECORD_TYPE\n");
        }
        stringBuffer.append("    .fontindex       = ").append(Integer.toHexString(this.getFontIndex())).append("\n");
        stringBuffer.append("    .formatindex     = ").append(Integer.toHexString(this.getFormatIndex())).append("\n");
        stringBuffer.append("    .celloptions     = ").append(Integer.toHexString(this.getCellOptions())).append("\n");
        stringBuffer.append("          .islocked  = ").append(this.isLocked()).append("\n");
        stringBuffer.append("          .ishidden  = ").append(this.isHidden()).append("\n");
        stringBuffer.append("          .recordtype= ").append(Integer.toHexString(this.getXFType())).append("\n");
        stringBuffer.append("          .parentidx = ").append(Integer.toHexString(this.getParentIndex())).append("\n");
        stringBuffer.append("    .alignmentoptions= ").append(Integer.toHexString(this.getAlignmentOptions())).append("\n");
        stringBuffer.append("          .alignment = ").append(this.getAlignment()).append("\n");
        stringBuffer.append("          .wraptext  = ").append(this.getWrapText()).append("\n");
        stringBuffer.append("          .valignment= ").append(Integer.toHexString(this.getVerticalAlignment())).append("\n");
        stringBuffer.append("          .justlast  = ").append(Integer.toHexString(this.getJustifyLast())).append("\n");
        stringBuffer.append("          .rotation  = ").append(Integer.toHexString(this.getRotation())).append("\n");
        stringBuffer.append("    .indentionoptions= ").append(Integer.toHexString(this.getIndentionOptions())).append("\n");
        stringBuffer.append("          .indent    = ").append(Integer.toHexString(this.getIndent())).append("\n");
        stringBuffer.append("          .shrinktoft= ").append(this.getShrinkToFit()).append("\n");
        stringBuffer.append("          .mergecells= ").append(this.getMergeCells()).append("\n");
        stringBuffer.append("          .readngordr= ").append(Integer.toHexString(this.getReadingOrder())).append("\n");
        stringBuffer.append("          .formatflag= ").append(this.isIndentNotParentFormat()).append("\n");
        stringBuffer.append("          .fontflag  = ").append(this.isIndentNotParentFont()).append("\n");
        stringBuffer.append("          .prntalgnmt= ").append(this.isIndentNotParentAlignment()).append("\n");
        stringBuffer.append("          .borderflag= ").append(this.isIndentNotParentBorder()).append("\n");
        stringBuffer.append("          .paternflag= ").append(this.isIndentNotParentPattern()).append("\n");
        stringBuffer.append("          .celloption= ").append(this.isIndentNotParentCellOptions()).append("\n");
        stringBuffer.append("    .borderoptns     = ").append(Integer.toHexString(this.getBorderOptions())).append("\n");
        stringBuffer.append("          .lftln     = ").append(Integer.toHexString(this.getBorderLeft())).append("\n");
        stringBuffer.append("          .rgtln     = ").append(Integer.toHexString(this.getBorderRight())).append("\n");
        stringBuffer.append("          .topln     = ").append(Integer.toHexString(this.getBorderTop())).append("\n");
        stringBuffer.append("          .btmln     = ").append(Integer.toHexString(this.getBorderBottom())).append("\n");
        stringBuffer.append("    .paleteoptns     = ").append(Integer.toHexString(this.getPaletteOptions())).append("\n");
        stringBuffer.append("          .leftborder= ").append(Integer.toHexString(this.getLeftBorderPaletteIdx())).append("\n");
        stringBuffer.append("          .rghtborder= ").append(Integer.toHexString(this.getRightBorderPaletteIdx())).append("\n");
        stringBuffer.append("          .diag      = ").append(Integer.toHexString(this.getDiag())).append("\n");
        stringBuffer.append("    .paleteoptn2     = ").append(Integer.toHexString(this.getAdtlPaletteOptions())).append("\n");
        stringBuffer.append("          .topborder = ").append(Integer.toHexString(this.getTopBorderPaletteIdx())).append("\n");
        stringBuffer.append("          .botmborder= ").append(Integer.toHexString(this.getBottomBorderPaletteIdx())).append("\n");
        stringBuffer.append("          .adtldiag  = ").append(Integer.toHexString(this.getAdtlDiag())).append("\n");
        stringBuffer.append("          .diaglnstyl= ").append(Integer.toHexString(this.getAdtlDiagLineStyle())).append("\n");
        stringBuffer.append("          .fillpattrn= ").append(Integer.toHexString(this.getAdtlFillPattern())).append("\n");
        stringBuffer.append("    .fillpaloptn     = ").append(Integer.toHexString(this.getFillPaletteOptions())).append("\n");
        stringBuffer.append("          .foreground= ").append(Integer.toHexString(this.getFillForeground())).append("\n");
        stringBuffer.append("          .background= ").append(Integer.toHexString(this.getFillBackground())).append("\n");
        stringBuffer.append("[/EXTENDEDFORMAT]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getFontIndex());
        littleEndianOutput.writeShort(this.getFormatIndex());
        littleEndianOutput.writeShort(this.getCellOptions());
        littleEndianOutput.writeShort(this.getAlignmentOptions());
        littleEndianOutput.writeShort(this.getIndentionOptions());
        littleEndianOutput.writeShort(this.getBorderOptions());
        littleEndianOutput.writeShort(this.getPaletteOptions());
        littleEndianOutput.writeInt(this.getAdtlPaletteOptions());
        littleEndianOutput.writeShort(this.getFillPaletteOptions());
    }

    @Override
    protected int getDataSize() {
        return 20;
    }

    @Override
    public short getSid() {
        return 224;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.field_1_font_index;
        n = 31 * n + this.field_2_format_index;
        n = 31 * n + this.field_3_cell_options;
        n = 31 * n + this.field_4_alignment_options;
        n = 31 * n + this.field_5_indention_options;
        n = 31 * n + this.field_6_border_options;
        n = 31 * n + this.field_7_palette_options;
        n = 31 * n + this.field_8_adtl_palette_options;
        n = 31 * n + this.field_9_fill_palette_options;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ExtendedFormatRecord) {
            ExtendedFormatRecord extendedFormatRecord = (ExtendedFormatRecord)object;
            if (this.field_1_font_index != extendedFormatRecord.field_1_font_index) {
                return false;
            }
            if (this.field_2_format_index != extendedFormatRecord.field_2_format_index) {
                return false;
            }
            if (this.field_3_cell_options != extendedFormatRecord.field_3_cell_options) {
                return false;
            }
            if (this.field_4_alignment_options != extendedFormatRecord.field_4_alignment_options) {
                return false;
            }
            if (this.field_5_indention_options != extendedFormatRecord.field_5_indention_options) {
                return false;
            }
            if (this.field_6_border_options != extendedFormatRecord.field_6_border_options) {
                return false;
            }
            if (this.field_7_palette_options != extendedFormatRecord.field_7_palette_options) {
                return false;
            }
            if (this.field_8_adtl_palette_options != extendedFormatRecord.field_8_adtl_palette_options) {
                return false;
            }
            return this.field_9_fill_palette_options == extendedFormatRecord.field_9_fill_palette_options;
        }
        return false;
    }
}

