/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.List;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.aggregates.DataValidityTable;
import org.apache.poi.hssf.record.aggregates.MergedCellsTable;
import org.apache.poi.hssf.record.aggregates.PageSettingsBlock;

final class RecordOrderer {
    private RecordOrderer() {
    }

    public static void addNewSheetRecord(List<RecordBase> list, RecordBase recordBase) {
        int n = RecordOrderer.findSheetInsertPos(list, recordBase.getClass());
        list.add(n, recordBase);
    }

    private static int findSheetInsertPos(List<RecordBase> list, Class<? extends RecordBase> clazz) {
        if (clazz == DataValidityTable.class) {
            return RecordOrderer.findDataValidationTableInsertPos(list);
        }
        if (clazz == MergedCellsTable.class) {
            return RecordOrderer.findInsertPosForNewMergedRecordTable(list);
        }
        if (clazz == GutsRecord.class) {
            return RecordOrderer.getGutsRecordInsertPos(list);
        }
        throw new RuntimeException("Unexpected record class (" + clazz.getName() + ")");
    }

    private static int findInsertPosForNewMergedRecordTable(List<RecordBase> list) {
        for (int i = list.size() - 2; i >= 0; --i) {
            RecordBase recordBase = list.get(i);
            if (!(recordBase instanceof Record)) continue;
            Record record = (Record)recordBase;
            switch (record.getSid()) {
                case 29: 
                case 65: 
                case 153: 
                case 160: 
                case 574: {
                    return i + 1;
                }
            }
        }
        throw new RuntimeException("Did not find Window2 record");
    }

    private static int findDataValidationTableInsertPos(List<RecordBase> list) {
        int n = list.size() - 1;
        if (!(list.get(n) instanceof EOFRecord)) {
            throw new IllegalStateException("Last sheet record should be EOFRecord");
        }
        while (n > 0) {
            Record record;
            RecordBase recordBase;
            if (RecordOrderer.isDVTPriorRecord(recordBase = list.get(--n))) {
                record = (Record)list.get(n + 1);
                if (!RecordOrderer.isDVTSubsequentRecord(record.getSid())) {
                    throw new IllegalStateException("Unexpected (" + record.getClass().getName() + ") found after (" + recordBase.getClass().getName() + ")");
                }
                return n + 1;
            }
            record = (Record)recordBase;
            if (RecordOrderer.isDVTSubsequentRecord(record.getSid())) continue;
            throw new IllegalStateException("Unexpected (" + record.getClass().getName() + ") while looking for DV Table insert pos");
        }
        return 0;
    }

    private static boolean isDVTPriorRecord(RecordBase recordBase) {
        if (recordBase instanceof MergedCellsTable) {
            return true;
        }
        short s = ((Record)recordBase).getSid();
        switch (s) {
            case 29: 
            case 65: 
            case 153: 
            case 160: 
            case 239: 
            case 351: 
            case 440: 
            case 442: 
            case 574: 
            case 2048: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDVTSubsequentRecord(short s) {
        switch (s) {
            case 10: 
            case 2146: 
            case 2151: 
            case 2152: {
                return true;
            }
        }
        return false;
    }

    private static int getDimensionsIndex(List<RecordBase> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof DimensionsRecord)) continue;
            return i;
        }
        throw new RuntimeException("DimensionsRecord not found");
    }

    private static int getGutsRecordInsertPos(List<RecordBase> list) {
        int n = RecordOrderer.getDimensionsIndex(list);
        int n2 = n - 1;
        while (n2 > 0) {
            RecordBase recordBase;
            if (!RecordOrderer.isGutsPriorRecord(recordBase = list.get(--n2))) continue;
            return n2 + 1;
        }
        throw new RuntimeException("Did not find insert point for GUTS");
    }

    private static boolean isGutsPriorRecord(RecordBase recordBase) {
        if (recordBase instanceof Record) {
            Record record = (Record)recordBase;
            switch (record.getSid()) {
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 34: 
                case 94: 
                case 95: 
                case 130: 
                case 523: 
                case 2057: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEndOfRowBlock(int n) {
        switch (n) {
            case 61: 
            case 93: 
            case 438: 
            case 574: {
                return true;
            }
            case 434: {
                return true;
            }
            case 10: {
                throw new RuntimeException("Found EOFRecord before WindowTwoRecord was encountered");
            }
        }
        return PageSettingsBlock.isComponentRecord(n);
    }

    public static boolean isRowBlockRecord(int n) {
        switch (n) {
            case 6: 
            case 253: 
            case 513: 
            case 515: 
            case 516: 
            case 517: 
            case 520: 
            case 545: 
            case 566: 
            case 638: 
            case 1212: {
                return true;
            }
        }
        return false;
    }
}

