/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.StringUtil;

public final class SupBookRecord
extends StandardRecord {
    public static final short sid = 430;
    private static final short SMALL_RECORD_SIZE = 4;
    private static final short TAG_INTERNAL_REFERENCES = 1025;
    private static final short TAG_ADD_IN_FUNCTIONS = 14849;
    private short field_1_number_of_sheets;
    private String field_2_encoded_url;
    private String[] field_3_sheet_names;
    private boolean _isAddInFunctions;

    public boolean isExternalReferences() {
        return this.field_3_sheet_names != null;
    }

    public SupBookRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.remaining();
        this.field_1_number_of_sheets = recordInputStream.readShort();
        if (n > 4) {
            this._isAddInFunctions = false;
            this.field_2_encoded_url = recordInputStream.readString();
            String[] stringArray = new String[this.field_1_number_of_sheets];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = recordInputStream.readString();
            }
            this.field_3_sheet_names = stringArray;
            return;
        }
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        short s = recordInputStream.readShort();
        if (s == 1025) {
            this._isAddInFunctions = false;
        } else if (s == 14849) {
            this._isAddInFunctions = true;
            if (this.field_1_number_of_sheets != 1) {
                throw new RuntimeException("Expected 0x0001 for number of sheets field in 'Add-In Functions' but got (" + this.field_1_number_of_sheets + ")");
            }
        } else {
            throw new RuntimeException("invalid EXTERNALBOOK code (" + Integer.toHexString(s) + ")");
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" [SUPBOOK ");
        if (this.isExternalReferences()) {
            stringBuffer.append("External References");
            stringBuffer.append(" nSheets=").append(this.field_1_number_of_sheets);
            stringBuffer.append(" url=").append(this.field_2_encoded_url);
        } else if (this._isAddInFunctions) {
            stringBuffer.append("Add-In Functions");
        } else {
            stringBuffer.append("Internal References ");
            stringBuffer.append(" nSheets= ").append(this.field_1_number_of_sheets);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    protected int getDataSize() {
        if (!this.isExternalReferences()) {
            return 4;
        }
        int n = 2;
        n += StringUtil.getEncodedSize(this.field_2_encoded_url);
        for (int i = 0; i < this.field_3_sheet_names.length; ++i) {
            n += StringUtil.getEncodedSize(this.field_3_sheet_names[i]);
        }
        return n;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_number_of_sheets);
        if (this.isExternalReferences()) {
            StringUtil.writeUnicodeString(littleEndianOutput, this.field_2_encoded_url);
            for (int i = 0; i < this.field_3_sheet_names.length; ++i) {
                StringUtil.writeUnicodeString(littleEndianOutput, this.field_3_sheet_names[i]);
            }
        } else {
            int n = this._isAddInFunctions ? 14849 : 1025;
            littleEndianOutput.writeShort(n);
        }
    }

    public short getNumberOfSheets() {
        return this.field_1_number_of_sheets;
    }

    @Override
    public short getSid() {
        return 430;
    }

    public String getURL() {
        String string = this.field_2_encoded_url;
        switch (string.charAt(0)) {
            case '\u0000': {
                return string.substring(1);
            }
            case '\u0001': {
                return SupBookRecord.decodeFileName(string);
            }
            case '\u0002': {
                return string.substring(1);
            }
        }
        return string;
    }

    private static String decodeFileName(String string) {
        return string.substring(1);
    }

    public String[] getSheetNames() {
        return (String[])this.field_3_sheet_names.clone();
    }
}

