/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.tofix.TofixDraw;
import org.openstreetmap.josm.plugins.tofix.TofixLayer;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToTask;
import org.openstreetmap.josm.plugins.tofix.bean.items.Item;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemKeeprightBean;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemKrakatoaBean;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintLinestring;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintMultipoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemOsmlintPoint;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemSmallcomponents;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemStrava;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemTigerdeltaBean;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemUnconnectedBean;
import org.openstreetmap.josm.plugins.tofix.bean.items.ItemUsaBuildingsBean;
import org.openstreetmap.josm.plugins.tofix.controller.ItemController;
import org.openstreetmap.josm.plugins.tofix.util.Download;
import org.openstreetmap.josm.tools.I18n;

public class TofixTask {
    ItemController itemController = new ItemController();
    Bounds bounds = null;
    DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
    Node node = null;
    TofixLayer tofixLayer = new TofixLayer("Tofix-layer");

    public AccessToTask work(Item item, AccessToTask accessToTask, double size) {
        if (Main.map != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer && !Main.main.getEditLayer().isModified()) {
            Main.main.removeLayer((Layer)Main.main.getEditLayer());
        }
        if (accessToTask.getTask_source().equals("unconnected")) {
            accessToTask = this.work_unconnected(item.getItemUnconnectedBean(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("keepright")) {
            accessToTask = this.work_keepright(item.getItemKeeprightBean(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("tigerdelta")) {
            accessToTask = this.work_tigerdelta(item.getItemTigerdeltaBean(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("nycbuildings")) {
            accessToTask = this.work_nycbuildings(item.getItemUsabuildingsBean(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("krakatoa")) {
            accessToTask = this.work_krakatoa(item.getItemKrakatoaBean(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("strava")) {
            accessToTask = this.work_strava(item.getItemStrava(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("components")) {
            accessToTask = this.work_smallcomponents(item.getItemSmallcomponents(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("osmlint-point")) {
            accessToTask = this.work_osmlintpoint(item.getItemOsmlintPoint(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("osmlint-linestring")) {
            accessToTask = this.work_osmlintlinestring(item.getItemOsmlintLinestring(), accessToTask, size);
        }
        if (accessToTask.getTask_source().equals("osmlint-multipoint")) {
            accessToTask = this.work_osmlintmultipoint(item.getItemOsmlintMultipoint(), accessToTask, size);
        }
        UploadDialog.getUploadDialog().getChangeset().getCommentsCount();
        return accessToTask;
    }

    private AccessToTask work_unconnected(ItemUnconnectedBean itemUnconnectedBean, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemUnconnectedBean.getKey());
        this.node = itemUnconnectedBean.get_node();
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_Node(this.tofixLayer, this.node.getCoor());
        Download.Download(this.downloadOsmTask, this.bounds, itemUnconnectedBean.getWay_id());
        return accessToTask;
    }

    private AccessToTask work_keepright(ItemKeeprightBean itemKeeprightBean, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemKeeprightBean.getKey());
        this.node = itemKeeprightBean.get_node();
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_Node(this.tofixLayer, this.node.getCoor());
        Download.Download(this.downloadOsmTask, this.bounds, itemKeeprightBean.getObject_id());
        return accessToTask;
    }

    private AccessToTask work_nycbuildings(ItemUsaBuildingsBean itemNycbuildingsBean, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemNycbuildingsBean.getKey());
        this.node = itemNycbuildingsBean.get_node();
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_Node(this.tofixLayer, this.node.getCoor());
        Download.Download(this.downloadOsmTask, this.bounds, itemNycbuildingsBean.osm_obj_id());
        return accessToTask;
    }

    private AccessToTask work_tigerdelta(ItemTigerdeltaBean itemTigerdeltaBean, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemTigerdeltaBean.getKey());
        List<List<Node>> list = itemTigerdeltaBean.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).getCoor().lat(), list.get(0).get(0).getCoor().lon()));
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_line(this.tofixLayer, this.node.getCoor(), list);
        Download.Download(this.downloadOsmTask, this.bounds, 0L);
        return accessToTask;
    }

    private AccessToTask work_krakatoa(ItemKrakatoaBean itemkrakatoaBean, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemkrakatoaBean.getKey());
        List<Node> list = itemkrakatoaBean.get_nodes();
        this.node = new Node(new LatLon(list.get(0).getCoor().lat(), list.get(0).getCoor().lon()));
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_nodes(this.tofixLayer, this.node.getCoor(), list);
        Download.Download(this.downloadOsmTask, this.bounds, 0L);
        return accessToTask;
    }

    private AccessToTask work_strava(ItemStrava itemStrava, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemStrava.getKey());
        this.node = itemStrava.get_node();
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_Node(this.tofixLayer, this.node.getCoor());
        Download.Download(this.downloadOsmTask, this.bounds, 0L);
        return accessToTask;
    }

    private AccessToTask work_smallcomponents(ItemSmallcomponents itemSmallcomponents, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemSmallcomponents.getKey());
        List<List<Node>> list = itemSmallcomponents.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).getCoor().lat(), list.get(0).get(0).getCoor().lon()));
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_line(this.tofixLayer, this.node.getCoor(), list);
        Download.Download(this.downloadOsmTask, this.bounds, 0L);
        return accessToTask;
    }

    private AccessToTask work_osmlintpoint(ItemOsmlintPoint itemOsmlintPoint, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintPoint.getKey());
        this.node = itemOsmlintPoint.get_node();
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_Node(this.tofixLayer, this.node.getCoor());
        Download.Download(this.downloadOsmTask, this.bounds, itemOsmlintPoint.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintlinestring(ItemOsmlintLinestring itemOsmlintLinestring, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintLinestring.getKey());
        List<List<Node>> list = itemOsmlintLinestring.get_nodes();
        this.node = new Node(new LatLon(list.get(0).get(0).getCoor().lat(), list.get(0).get(0).getCoor().lon()));
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_line(this.tofixLayer, this.node.getCoor(), list);
        Download.Download(this.downloadOsmTask, this.bounds, itemOsmlintLinestring.getWay());
        return accessToTask;
    }

    private AccessToTask work_osmlintmultipoint(ItemOsmlintMultipoint itemOsmlintMultipoint, AccessToTask accessToTask, double size) {
        accessToTask.setKey(itemOsmlintMultipoint.getKey());
        List<Node> list = itemOsmlintMultipoint.get_nodes();
        this.node = new Node(new LatLon(list.get(0).getCoor().lat(), list.get(0).getCoor().lon()));
        this.bounds = new Bounds(this.node.getCoor().toBBox(size).toRectangle());
        TofixDraw.draw_nodes(this.tofixLayer, this.node.getCoor(), list);
        Download.Download(this.downloadOsmTask, this.bounds, itemOsmlintMultipoint.getWay());
        return accessToTask;
    }

    public void task_complete(Item item, AccessToTask accessToTask) {
        DecimalFormat myFormatter = new DecimalFormat("#,###");
        String num = myFormatter.format(item.getTaskCompleteBean().getTotal());
        String message = "Task " + accessToTask.getTask_name() + " is complete\n" + num + " issues fixed";
        JOptionPane.showMessageDialog(Main.panel, I18n.tr((String)message, (Object[])new Object[0]));
    }
}

