/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.plugins.tofix.TofixTask;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToTask;
import org.openstreetmap.josm.plugins.tofix.bean.FixedBean;
import org.openstreetmap.josm.plugins.tofix.bean.ListTaskBean;
import org.openstreetmap.josm.plugins.tofix.bean.TrackBean;
import org.openstreetmap.josm.plugins.tofix.bean.items.Item;
import org.openstreetmap.josm.plugins.tofix.controller.ItemController;
import org.openstreetmap.josm.plugins.tofix.controller.ItemTrackController;
import org.openstreetmap.josm.plugins.tofix.controller.ListTaskController;
import org.openstreetmap.josm.plugins.tofix.util.Status;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

public class TofixDialog
extends ToggleDialog
implements ActionListener {
    private final SideButton skipButton;
    private final SideButton fixedButton;
    private final SideButton noterrorButton;
    private Shortcut skipShortcut = null;
    private Shortcut fixedShortcut = null;
    private Shortcut noterrorButtonShortcut = null;
    JSlider slider = new JSlider(0, 1, 5, 1);
    double zise = 0.001;
    AccessToTask mainAccessToTask = null;
    ListTaskBean listTaskBean = null;
    ListTaskController listTaskController = new ListTaskController();
    Item item = new Item();
    ItemController itemController = new ItemController();
    MapView mv;
    ItemTrackController itemTrackController;
    JTabbedPane TabbedPanel;
    JPanel jcontenTasks;
    JPanel valuePanel;
    JPanel jcontenConfig;
    JPanel panelslide;
    JosmUserIdentityManager josmUserIdentityManager;
    TofixTask tofixTask;
    UploadAction uploadAction;

    public TofixDialog() {
        super(I18n.tr((String)"To-fix", (Object[])new Object[0]), "icontofix", I18n.tr((String)"Open to-fix window.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Tool:To-fix", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Tool:To-fix", (Object[])new Object[0])}), (int)84, (int)5010), 170);
        this.mv = Main.map.mapView;
        this.itemTrackController = new ItemTrackController();
        this.TabbedPanel = new JTabbedPane();
        this.jcontenTasks = new JPanel(new GridLayout(2, 1));
        this.valuePanel = new JPanel(new GridLayout(1, 1));
        this.jcontenConfig = new JPanel(new GridLayout(2, 1));
        this.panelslide = new JPanel(new GridLayout(1, 1));
        this.josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        this.tofixTask = new TofixTask();
        this.uploadAction = new UploadAction();
        this.skipButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.tr((String)"Skip", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"mapmode", (String)"skip.png"));
                this.putValue("ShortDescription", I18n.tr((String)"Skip Error", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TofixDialog.this.skip();
            }
        });
        this.skipButton.setEnabled(false);
        this.fixedButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.tr((String)"Fixed", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"mapmode", (String)"fixed.png"));
                this.putValue("ShortDescription", I18n.tr((String)"Fixed Error", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                APIDataSet apiData = new APIDataSet(Main.main.getCurrentDataSet());
                Main.map.mapView.getEditLayer().data.getChangeSetTags().put("comment", TofixDialog.this.mainAccessToTask.getTask_comment());
                TofixDialog.this.uploadAction.uploadData(Main.map.mapView.getEditLayer(), apiData);
                if (!UploadDialog.getUploadDialog().isCanceled()) {
                    TofixDialog.this.fixed();
                }
            }
        });
        this.fixedButton.setEnabled(false);
        this.noterrorButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", I18n.tr((String)"Not an error", (Object[])new Object[0]));
                this.putValue("SmallIcon", ImageProvider.get((String)"mapmode", (String)"noterror.png"));
                this.putValue("ShortDescription", I18n.tr((String)"Not an error", (Object[])new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TofixDialog.this.noterror();
            }
        });
        this.noterrorButton.setEnabled(false);
        JLabel title_tasks = new JLabel();
        title_tasks.setText("<html><a href=\"\">List of tasks</a></html>");
        title_tasks.setCursor(new Cursor(12));
        title_tasks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OpenBrowser.displayUrl((String)"http://osmlab.github.io/to-fix/");
            }
        });
        this.jcontenTasks.add(title_tasks);
        ArrayList<String> tasksList = new ArrayList<String>();
        tasksList.add("Select a task ...");
        if (Status.isInternetReachable()) {
            this.listTaskBean = this.listTaskController.getListTasksBean();
            for (int i = 0; i < this.listTaskBean.getTasks().size(); ++i) {
                tasksList.add(this.listTaskBean.getTasks().get(i).getTitle());
            }
            JComboBox<String> jcomboBox = new JComboBox<String>(tasksList.toArray(new String[0]));
            this.valuePanel.add(jcomboBox);
            jcomboBox.addActionListener(this);
            this.jcontenTasks.add(this.valuePanel);
            this.jcontenConfig.add(new Label(I18n.tr((String)"Set download area (m\u00b2)", (Object[])new Object[0])));
            this.slider.setMinorTickSpacing(2);
            this.slider.setMajorTickSpacing(5);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
            table.put(1, new JLabel(I18n.tr((String)"~.02", (Object[])new Object[0])));
            table.put(3, new JLabel("~.20"));
            table.put(5, new JLabel("~.40"));
            this.slider.setLabelTable(table);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    TofixDialog.this.zise = (double)TofixDialog.this.slider.getValue() * 0.001;
                }
            });
            this.panelslide.add(this.slider);
            this.jcontenConfig.add(this.panelslide);
            this.valuePanel.setBorder(BorderFactory.createEtchedBorder());
            this.panelslide.setBorder(BorderFactory.createEtchedBorder());
            this.TabbedPanel.addTab("Tasks", this.jcontenTasks);
            this.TabbedPanel.addTab("Config", this.jcontenConfig);
            this.createLayout(this.TabbedPanel, false, Arrays.asList(this.skipButton, this.noterrorButton, this.fixedButton));
            if (!Status.server()) {
                jcomboBox.setEnabled(false);
                this.skipButton.setEnabled(false);
                this.fixedButton.setEnabled(false);
                this.noterrorButton.setEnabled(false);
            } else {
                this.mainAccessToTask = new AccessToTask("mixedlayer", "keepright", false);
                this.skipShortcut = Shortcut.registerShortcut((String)"tofix:skip", (String)I18n.tr((String)"tofix:Skip item", (Object[])new Object[0]), (int)83, (int)5007);
                Main.registerActionShortcut((Action)new Skip_key_Action(), (Shortcut)this.skipShortcut);
                this.fixedShortcut = Shortcut.registerShortcut((String)"tofix:fixed", (String)I18n.tr((String)"tofix:Fixed item", (Object[])new Object[0]), (int)70, (int)5007);
                Main.registerActionShortcut((Action)new Fixed_key_Action(), (Shortcut)this.fixedShortcut);
                this.noterrorButtonShortcut = Shortcut.registerShortcut((String)"tofix:noterror", (String)I18n.tr((String)"tofix:Not a Error item", (Object[])new Object[0]), (int)78, (int)5007);
                Main.registerActionShortcut((Action)new NotError_key_Action(), (Shortcut)this.noterrorButtonShortcut);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComboBox cb = (JComboBox)e.getSource();
        if (cb.getSelectedIndex() != 0) {
            this.mainAccessToTask.setTask_name(this.listTaskBean.getTasks().get(cb.getSelectedIndex() - 1).getTitle());
            this.mainAccessToTask.setTask_id(this.listTaskBean.getTasks().get(cb.getSelectedIndex() - 1).getId());
            this.mainAccessToTask.setTask_source(this.listTaskBean.getTasks().get(cb.getSelectedIndex() - 1).getSource());
            this.mainAccessToTask.setTask_comment(this.listTaskBean.getTasks().get(cb.getSelectedIndex() - 1).getComment());
            this.get_new_item();
            this.skipButton.setEnabled(true);
            this.fixedButton.setEnabled(true);
            this.noterrorButton.setEnabled(true);
        } else {
            this.skipButton.setEnabled(false);
            this.fixedButton.setEnabled(false);
            this.noterrorButton.setEnabled(false);
        }
    }

    public void edit() {
        if (this.mainAccessToTask.isAccess()) {
            TrackBean trackBean = new TrackBean();
            trackBean.getAttributes().setAction("edit");
            trackBean.getAttributes().setEditor("josm");
            trackBean.getAttributes().setUser(this.josmUserIdentityManager.getUserName());
            trackBean.getAttributes().setKey(this.mainAccessToTask.getKey());
            this.itemTrackController.send_track_edit(this.mainAccessToTask.getTrack_url(), trackBean);
        }
    }

    public void skip() {
        if (this.mainAccessToTask.isAccess()) {
            TrackBean trackBean = new TrackBean();
            trackBean.getAttributes().setAction("skip");
            trackBean.getAttributes().setEditor("josm");
            trackBean.getAttributes().setUser(this.josmUserIdentityManager.getUserName());
            trackBean.getAttributes().setKey(this.mainAccessToTask.getKey());
            this.itemTrackController.send_track_skip(this.mainAccessToTask.getTrack_url(), trackBean);
        }
        this.get_new_item();
    }

    public void fixed() {
        if (this.mainAccessToTask.isAccess()) {
            FixedBean fixedBean = new FixedBean();
            fixedBean.setUser(this.josmUserIdentityManager.getUserName());
            fixedBean.setKey(this.mainAccessToTask.getKey());
            this.itemTrackController.send_track_fix(this.mainAccessToTask.getFixed_url(), fixedBean);
        }
        this.get_new_item();
    }

    public void noterror() {
        if (this.mainAccessToTask.isAccess()) {
            FixedBean NoterrorBean = new FixedBean();
            NoterrorBean.setUser(this.josmUserIdentityManager.getUserName());
            NoterrorBean.setKey(this.mainAccessToTask.getKey());
            this.itemTrackController.send_track_noterror(this.mainAccessToTask.getNoterror_url(), NoterrorBean);
        }
        this.get_new_item();
    }

    private void get_new_item() {
        this.item.setStatus(0);
        this.itemController.setAccessToTask(this.mainAccessToTask);
        this.item = this.itemController.getItem();
        switch (this.item.getStatus()) {
            case 200: {
                this.mainAccessToTask.setAccess(true);
                this.mainAccessToTask = this.tofixTask.work(this.item, this.mainAccessToTask, this.zise);
                this.edit();
                break;
            }
            case 410: {
                this.mainAccessToTask.setAccess(false);
                this.tofixTask.task_complete(this.item, this.mainAccessToTask);
                break;
            }
            case 503: {
                this.mainAccessToTask.setAccess(false);
                JOptionPane.showMessageDialog(Main.panel, I18n.tr((String)"Maintenance server", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                break;
            }
            case 520: {
                this.mainAccessToTask.setAccess(false);
                JLabel text = new JLabel();
                text.setText(I18n.tr((String)"<html>Something went wrong, please update the plugin or report an issue at <a href=\"\">josm-tofix-plugin/issues</a></html>", (Object[])new Object[0]));
                text.setCursor(new Cursor(12));
                text.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        OpenBrowser.displayUrl((String)"https://github.com/osmlab/tofix-plugin/issues");
                    }
                });
                JOptionPane.showMessageDialog(Main.panel, text, I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                break;
            }
            default: {
                this.mainAccessToTask.setAccess(false);
                JOptionPane.showMessageDialog(Main.panel, I18n.tr((String)"Something went wrong, try again", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            }
        }
    }

    public class NotError_key_Action
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            TofixDialog.this.noterror();
        }
    }

    public class Fixed_key_Action
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            APIDataSet apiData = new APIDataSet(Main.main.getCurrentDataSet());
            Main.map.mapView.getEditLayer().data.getChangeSetTags().put("comment", TofixDialog.this.mainAccessToTask.getTask_comment());
            TofixDialog.this.uploadAction.uploadData(Main.map.mapView.getEditLayer(), apiData);
            if (!UploadDialog.getUploadDialog().isCanceled()) {
                TofixDialog.this.fixed();
            }
        }
    }

    public class Skip_key_Action
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            TofixDialog.this.skip();
        }
    }
}

